% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimData.R
\name{trimData}
\alias{trimData}
\title{Trim data for downstream analyses}
\usage{
trimData(data, start.date, start.time, n.days, bin = 1, t.cycle = 24)
}
\arguments{
\item{data}{Input data file. This must be DAM scanned monitor files, saved in 1-min intervals starting at time 00:00.}

\item{start.date}{Define starting date for analysis. Date inputs must be in this form: "DD Mon YY"; August 6, 2020 must be input as "6 Aug 20". Any other form will result in computation errors.}

\item{start.time}{Define start time for analysis. Times must be input in the 24-h format and in the following form: "HH:MM"; 10 AM must be "10:00" and 10 PM must be "22:00".}

\item{n.days}{Number of days to analyse.}

\item{bin}{Intervals in which data are sampled (in minutes). This defaults to 1.}

\item{t.cycle}{Define the period of the environmental cycle or a single day in hours. This defaults to 24.}
}
\value{
A \code{data.frame} containing trimmed data.
}
\description{
trimData() allows users to define start date, start time and number of days for analysing data sets.
}
\examples{
td <- trimData(data = df, start.date = "19 Dec 20", start.time = "21:00",
n.days = 10, bin = 1, t.cycle = 24)
}
