% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pheno_ts.R
\name{get_pheno_ts}
\alias{get_pheno_ts}
\title{Obtain phenological time-series from the PhenoCam server}
\usage{
get_pheno_ts(site, vegType, roiID, type = "3day")
}
\arguments{
\item{site}{site name as character string}

\item{vegType}{2-letter character string indicating the vegetation type}

\item{roiID}{four-digit integer number indicating the ROI number}

\item{type}{a character string indicating what data to be obtained, can be '1day', '3day', or 'roistats'.}
}
\value{
a data.table containing phenological data over time.
}
\description{
Obtain phenological time-series from the PhenoCam server
}
\examples{

ts <- get_pheno_ts(site = 'dukehw', vegType = 'DB', roiID = 1000)
head(ts)

}
