% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tagloss_mcmc.R
\name{Tagloss_mcmc}
\alias{Tagloss_mcmc}
\title{Bayesian model of tag loss using a CMR database.}
\usage{
Tagloss_mcmc(
  data = stop("A database formated using Tagloss_format() must be used"),
  parameters = stop("Priors must be supplied"),
  fixed.parameters = NULL,
  model_before = NULL,
  model_after = NULL,
  mc.cores = detectCores(all.tests = FALSE, logical = TRUE),
  groups = detectCores(all.tests = FALSE, logical = TRUE),
  n.iter = 10000,
  n.chains = 1,
  n.adapt = 100,
  thin = 30,
  trace = FALSE,
  traceML = FALSE,
  adaptive = FALSE,
  adaptive.lag = 500,
  adaptive.fun = function(x) {
     ifelse(x > 0.234, 1.3, 0.7)
 },
  intermediate = NULL,
  filename = "intermediate.Rdata",
  previous = NULL
)
}
\arguments{
\item{data}{An object formated using Tagloss_format}

\item{parameters}{A data.frame with priors; see description and examples}

\item{fixed.parameters}{Set of fixed parameters}

\item{model_before}{Transformation of parameters before to use Tagloss_model()}

\item{model_after}{Transformation of parameters after to use Tagloss_model()}

\item{mc.cores}{Number of cores to use for parallel computing}

\item{groups}{Number of groups for parallel computing}

\item{n.iter}{Number of iterations for each chain}

\item{n.chains}{Number of chains}

\item{n.adapt}{Number of iteration to stabilize likelihood}

\item{thin}{Interval for thinning Markov chain}

\item{trace}{Or FALSE or period to show progress}

\item{traceML}{TRUE or FALSE to show ML}

\item{adaptive}{Should an adaptive process for SDProp be used}

\item{adaptive.lag}{Lag to analyze the SDProp value in an adaptive context}

\item{adaptive.fun}{Function used to change the SDProp}

\item{intermediate}{Or NULL of period to save intermediate result}

\item{filename}{Name of file in which intermediate results are saved}

\item{previous}{The content of the file in which intermediate results are saved}
}
\value{
Return a list object with the Bayesian model describing tag loss.
}
\description{
This function fits a model of tag loss using a CMR database using Bayesian mcmc.\cr
The parameters must be stored in a data.frame with named rows for each parameter with the following columns:\cr
\itemize{
  \item Density. The density function name, example \code{dnorm}, \code{dlnorm}, \code{dunif}
  \item Prior1. The first parameter to send to the \code{Density} function
  \item Prior2. The second parameter to send to the \code{Density} function
  \item SDProp. The standard error from new proposition value of this parameter
  \item Min. The minimum value for this parameter
  \item Max. The maximum value for this parameter
  \item Init. The initial value for this parameter
}
}
\details{
Tagloss_mcmc Bayesian model of tag loss using a CMR database.
}
\examples{
\dontrun{
library(phenology)
# Example
data_f_21 <- Tagloss_format(outLR, model="21")

# model fitted by Rivalan et al. 2005
par <- c(a0_2=-5.43E-2, a1_2=-103.52, a4_2=5.62E-4, 
         delta_1=3.2E-4)
pfixed <- c(a2_2=0, a3_2=0, a2_1=0, a3_1=0)
model_before <- "par['a0_1']=par['a0_2'];par['a1_1']=par['a1_2'];par['a4_1']=par['a4_2']"
o <- Tagloss_fit(data=data_f_21, fitted.parameters=par, fixed.parameters=pfixed, 
                 model_before=model_before)
pMCMC <- Tagloss_mcmc_p(o, accept=TRUE)
o_MCMC <- Tagloss_mcmc(data=data_f_21, parameters=pMCMC, fixed.parameters=pfixed, 
                 model_before=model_before, 
                 n.iter=10000, n.chains = 1, n.adapt = 100, thin=30)
}
}
\seealso{
Other Model of Tag-loss: 
\code{\link{Tagloss_LengthObs}()},
\code{\link{Tagloss_L}()},
\code{\link{Tagloss_cumul}()},
\code{\link{Tagloss_daymax}()},
\code{\link{Tagloss_fit}()},
\code{\link{Tagloss_format}()},
\code{\link{Tagloss_mcmc_p}()},
\code{\link{Tagloss_model}()},
\code{\link{Tagloss_simulate}()},
\code{\link{logLik.Tagloss}()},
\code{\link{o_4p_p1p2}},
\code{\link{plot.TaglossData}()},
\code{\link{plot.Tagloss}()}
}
\author{
Marc Girondot
}
\concept{Model of Tag-loss}
