% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenology2fitRMU.R
\name{phenology2fitRMU}
\alias{phenology2fitRMU}
\title{Create the data to be used with fitRMU() for a summary(phenology).}
\usage{
phenology2fitRMU(
  phenologyout = stop("A result obtained from summary(phenology)"),
  col.mean = "with_obs_Mean_ML",
  col.var = "with_obs_Var_ML",
  rookeries.names.grep = "(.+)-.+",
  years.grep = ".+-(.+)$",
  limit.cv = +Inf,
  limit.sd = +Inf,
  density = "dgamma"
)
}
\arguments{
\item{phenologyout}{A result of plot.phenology() or summary()}

\item{col.mean}{Name of the column to be used as mean value. Can be a vector.}

\item{col.var}{Name of the column to be used as variance value. Can be a vector.}

\item{rookeries.names.grep}{The pattern to return the rookery name from names of timeseries.}

\item{years.grep}{The pattern to return the year from names of timeseries.}

\item{limit.cv}{Remove data with higher coefficient of variation than the limit.}

\item{limit.sd}{Remove data with higher standard deviation than the limit.}

\item{density}{What density should be used. Can be dnorm or dgamma. Can be a vector.}
}
\value{
Return a list with elements ready to be used with fitRMU().
}
\description{
This function takes the result of plot.phenology() and generates the information 
to be used with fitRMU().\cr
The value of density can be dnorm or dgamma. dnorm is better if ML results are used and 
dgamma is for MCMC.\cr
Here are some example of regular expressions (regex) in grep:\cr
If format of timeseries is beachname-2005: rookeries.names.grep="(.+)-.+", years.grep=".+-(.+)$"\cr
gsub("(.+)-.+", "\\1", "beachname-2005"); gsub(".+-(.+)$", "\\1", "beachname-2005")\cr
If format of timeseries is beachname-2005-2006: rookeries.names.grep="(.+)-.+", years.grep=".+-([0-9]{4,})-.+$"\cr
gsub("(.+)-.+", "\\1", "beachname-2005-2006"); gsub(".+-([0-9]{4,})-.+$", "\\1", "beachname-2005-2006")\cr
If format of timeseries is beachname-20052006: rookeries.names.grep="(.+)-.+", years.grep=".+-([0-9]{4,})([0-9]{4,})$"\cr
gsub("(.+)-.+", "\\1", "beachname-20052006"); gsub(".+-([0-9]{4,})([0-9]{4,})$", "\\1", "beachname-20052006")\cr
The return is a list with these elements: \cr
RMU.data, years.byrow, colname.year, and RMU.names.\cr
If density is a vector, the density used is linked to the rank of the timeseries in phenologyout.
}
\details{
phenology2fitRMU is used to prepare output of phenology to be used by fitRMU()
}
\examples{
\dontrun{
library("phenology")
}
}
\seealso{
Other Phenology model: 
\code{\link{AutoFitPhenology}()},
\code{\link{BE_to_LBLE}()},
\code{\link{Gratiot}},
\code{\link{LBLE_to_BE}()},
\code{\link{LBLE_to_L}()},
\code{\link{L_to_LBLE}()},
\code{\link{MarineTurtles_2002}},
\code{\link{MinBMinE_to_Min}()},
\code{\link{adapt_parameters}()},
\code{\link{add_SE}()},
\code{\link{add_phenology}()},
\code{\link{extract_result}()},
\code{\link{fit_phenology}()},
\code{\link{likelihood_phenology}()},
\code{\link{logLik.phenology}()},
\code{\link{map_Gratiot}},
\code{\link{map_phenology}()},
\code{\link{par_init}()},
\code{\link{phenology_MHmcmc_p}()},
\code{\link{phenology_MHmcmc}()},
\code{\link{phenology}()},
\code{\link{plot.phenologymap}()},
\code{\link{plot.phenology}()},
\code{\link{plot_delta}()},
\code{\link{plot_phi}()},
\code{\link{print.phenologymap}()},
\code{\link{print.phenologyout}()},
\code{\link{print.phenology}()},
\code{\link{remove_site}()},
\code{\link{result_Gratiot1}},
\code{\link{result_Gratiot2}},
\code{\link{result_Gratiot_Flat}},
\code{\link{result_Gratiot_mcmc}},
\code{\link{result_Gratiot}},
\code{\link{summary.phenologymap}()},
\code{\link{summary.phenologyout}()},
\code{\link{summary.phenology}()}
}
\author{
Marc Girondot
}
\concept{Fill gaps for RMU}
\concept{Phenology model}
