% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.TaglossData.R
\name{plot.TaglossData}
\alias{plot.TaglossData}
\title{Plot data used for tagloss analysis.}
\usage{
\method{plot}{TaglossData}(
  x,
  ...,
  categories = c("N22", "N21", "N11", "N10", "N20"),
  col = grey(seq(from = 0.9, to = 0, length.out = length(categories))),
  title.legend = "Tag history",
  categories.legend = categories,
  show.legend = TRUE
)
}
\arguments{
\item{x}{A result for Tagloss_format.}

\item{...}{Graphic parameters, see par().}

\item{categories}{Categories to display.}

\item{col}{The ramp of colors used for the categories.}

\item{title.legend}{Title for legend box.}

\item{categories.legend}{Name of categories to show in legend box.}

\item{show.legend}{Should the legend box be shown ?}
}
\value{
Nothing
}
\description{
This function plots the result of Tagloss_format().\cr
The default ramp of colors is a grey ramp.
}
\details{
plot.TaglossData plots formated data used for tagloss analysis
}
\examples{
\dontrun{
library(phenology)
# Example
data_f_21 <- Tagloss_format(outLR, model="21")
plot(data_f_21)
}
}
\seealso{
Other Model of Tag-loss: 
\code{\link{Tagloss_LengthObs}()},
\code{\link{Tagloss_L}()},
\code{\link{Tagloss_cumul}()},
\code{\link{Tagloss_daymax}()},
\code{\link{Tagloss_fit}()},
\code{\link{Tagloss_format}()},
\code{\link{Tagloss_mcmc_p}()},
\code{\link{Tagloss_mcmc}()},
\code{\link{Tagloss_model}()},
\code{\link{Tagloss_simulate}()},
\code{\link{logLik.Tagloss}()},
\code{\link{o_4p_p1p2}},
\code{\link{plot.Tagloss}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{Model of Tag-loss}
