% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{mapDiseaseToPhecode}
\alias{mapDiseaseToPhecode}
\title{Map diseases to phecodes via HPO terms}
\usage{
mapDiseaseToPhecode(
  diseaseHpoMap = phers::diseaseHpoMap,
  hpoPhecodeMap = phers::hpoPhecodeMap
)
}
\arguments{
\item{diseaseHpoMap}{A data.table containing the mapping between diseases and
HPO terms. Must have columns \code{disease_id} and \code{term_id}. Default is the map
included in this package.}

\item{hpoPhecodeMap}{A data.table containing the mapping between HPO terms
and phecodes. Must have columns \code{term_id} and \code{phecode}. Default is the map
included in this package.}
}
\value{
A data.table with columns \code{disease_id} and \code{phecode}.
}
\description{
A mapping of diseases to their clinical features, represented as phecodes,
is required for calculating phenotype risk scores.
}
\examples{
library('data.table')

# map ICD codes to phecodes
phecodeOccurrences = getPhecodeOccurrences(icdSample)

# calculate weights
weights = getWeights(demoSample, phecodeOccurrences)

# OMIM disease IDs for which to calculate phenotype risk scores
diseaseId = 154700

# map diseases to phecodes
diseasePhecodeMap = mapDiseaseToPhecode()

# calculate scores
scores = getScores(
  demoSample, phecodeOccurrences, weights, diseasePhecodeMap[disease_id == diseaseId])

# calculate residual scores
rscores = getResidualScores(demoSample, scores, glmFormula = ~ sex)
}
\seealso{
\code{\link[=getScores]{getScores()}}, \code{\link[=phers]{phers()}}
}
