% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concatenate_soundfiles.R
\name{concatenate_soundfiles}
\alias{concatenate_soundfiles}
\title{Concatenate sounds}
\usage{
concatenate_soundfiles(
  path,
  result_file_name = "concatenated",
  annotation = "textgrid"
)
}
\arguments{
\item{path}{path to the directory with soundfiles.}

\item{result_file_name}{name of the result and annotation files.}

\item{annotation}{there are several variants: "textgrid" for Praat TextGrid, "eaf" for ELAN's .eaf file, or "exb" for EXMARaLDA's .exb file}
}
\value{


no output
}
\description{
Creates a sound file and a Praat TextGrid whose interval labels are the original names of the sound
}
\examples{
# create two files in a temprary folder "test_folder"
s1 <-  system.file("extdata", "test.wav", package = "phonfieldwork")
s2 <-  system.file("extdata", "post.wav", package = "phonfieldwork")
tdir <- tempdir()
file.copy(c(s1, s2), tdir)

# here are two .wav files in a folder
list.files(tdir)
# [1] "post.wav" "test.wav"

# Concatenate all files from the folder into concatenated.wav and create corresponding TextGrid
concatenate_soundfiles(path = tdir, result_file_name = "concatenated")

list.files(tdir)
# [1] "concatenated.TextGrid" "concatenated.wav" "post.wav" "test.wav" ...
}
\author{
George Moroz <agricolamz@gmail.com>
}
