% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.spectrum.r
\name{check_spectrum}
\alias{check_spectrum}
\title{Sanity check a spectrum}
\usage{
check_spectrum(w.length, s.irrad)
}
\arguments{
\item{w.length}{numeric vector of wavelengths (nm).}

\item{s.irrad}{numeric Corresponding vector of spectral (energy) irradiances
(W m-2 nm-1).}
}
\value{
A single \code{logical} value indicating whether test was passed or
  not
}
\description{
Checks spectral irradiance data in \code{numeric} vectors for
compliance with assumptions used in calculations.
}
\examples{
with(sun.data, check_spectrum(w.length, s.e.irrad))

}
\seealso{
Other data validity check functions: 
\code{\link{check_spct}()},
\code{\link{check_w.length}()}
}
\concept{data validity check functions}
