% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbindspct.r
\name{rbindspct}
\alias{rbindspct}
\title{Row-bind spectra}
\usage{
rbindspct(l, use.names = TRUE, fill = TRUE, idfactor = TRUE)
}
\arguments{
\item{l}{A \code{source_mspct}, \code{filter_mspct}, \code{reflector_mspct},
\code{response_mspct}, \code{chroma_mspct}, \code{cps_mspct},
\code{generic_mspct} object or a list containing \code{source_spct},
\code{filter_spct}, \code{reflector_spct}, \code{response_spct},
\code{chroma_spct}, \code{cps_spct}, or \code{generic_spct} objects.}

\item{use.names}{logical If \code{TRUE} items will be bound by matching
column names. By default \code{TRUE} for \code{rbindspct}. Columns with
duplicate names are bound in the order of occurrence, similar to base. When
TRUE, at least one item of the input list has to have non-null column
names.}

\item{fill}{logical If \code{TRUE} fills missing columns with NAs. By default
\code{TRUE}. When \code{TRUE}, \code{use.names} has also to be \code{TRUE},
and all items of the input list have to have non-null column names.}

\item{idfactor}{logical or character Generates an index column of
\code{factor} type. Default is (\code{idfactor=TRUE}) for both lists and
\code{_mspct} objects. If \code{idfactor=TRUE} then the column is auto
named \code{spct.idx}. Alternatively the column name can be directly
provided to \code{idfactor} as a character string.}
}
\value{
An spectral object of a type common to all bound items containing a
  concatenation of all the items passed in. If the argument 'idfactor' is
  TRUE, then a factor 'spct.idx' will be added to the returned spectral
  object.
}
\description{
A wrapper on \code{dplyr::rbind_fill} that preserves class and other
attributes of spectral objects.
}
\details{
Each item of \code{l} should be a spectrum, including \code{NULL}
  (skipped) or an empty object (0 rows). \code{rbindspc} is most useful when
  there are a variable number of (potentially many) objects to stack.
  \code{rbindspct} always returns at least a \code{generic_spct} as long as
  all elements in l are spectra.
}
\note{
Note that any additional 'user added' attributes that might exist on
  individual items of the input list will not be preserved in the result.
  The attributes used by the \code{photobiology} package are preserved, and
  if they are not consistent across the bound spectral objects, a warning is
  issued.

\code{dplyr::rbind_fill} is called internally and the result returned is
  the highest class in the inheritance hierarchy which is common to all
  elements in the list. If not all members of the list belong to one of the
  \code{_spct} classes, an error is triggered. The function sets all data in
  \code{source_spct} and \code{response_spct} objects supplied as arguments
  into energy-based quantities, and all data in \code{filter_spct} objects
  into transmittance before the row binding is done. If any member spectrum
  is tagged, it is untagged before row binding.
}
\examples{
# default, adds factor 'spct.idx' with letters as levels
spct <- rbindspct(list(sun.spct, sun.spct))
spct
class(spct)

# adds factor 'spct.idx' with letters as levels
spct <- rbindspct(list(sun.spct, sun.spct), idfactor = TRUE)
head(spct)
class(spct)

# adds factor 'spct.idx' with the names given to the spectra in the list
# supplied as formal argument 'l' as levels
spct <- rbindspct(list(one = sun.spct, two = sun.spct), idfactor = TRUE)
head(spct)
class(spct)

# adds factor 'ID' with the names given to the spectra in the list
# supplied as formal argument 'l' as levels
spct <- rbindspct(list(one = sun.spct, two = sun.spct),
                  idfactor = "ID")
head(spct)
class(spct)

}
