% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.normalize.r
\name{getNormalized}
\alias{getNormalized}
\alias{getNormalised}
\alias{getNormalization}
\alias{getNormalisation}
\title{Get the "normalized" attribute}
\usage{
getNormalized(x, .force.numeric = FALSE)

getNormalised(x, .force.numeric = FALSE)

getNormalization(x)

getNormalisation(x)
}
\arguments{
\item{x}{a generic_spct object}

\item{.force.numeric}{logical If \code{TRUE} always silently return a
numeric value, with \code{FALSE} encoded as zero, and character values
as \code{NA}.}
}
\value{
numeric or logical (possibly character for objects created with
  earlier versions).
}
\description{
Function to read the "normalized" attribute of an existing generic_spct
object.
}
\note{
if x is not a \code{generic_spct} object, \code{NA} is returned

\code{getNormalised()} is a synonym for this \code{getNormalized()}
  method.
}
\examples{

sun_norm.spct <- normalize(sun.spct)

getNormalized(sun.spct)
getNormalization(sun.spct)

}
\seealso{
Other rescaling functions: 
\code{\link{fscale}()},
\code{\link{fshift}()},
\code{\link{getScaled}()},
\code{\link{is_normalized}()},
\code{\link{is_scaled}()},
\code{\link{normalize}()},
\code{\link{setNormalized}()},
\code{\link{setScaled}()}
}
\concept{rescaling functions}
