% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{setGenericSpct}
\alias{setGenericSpct}
\alias{setCalibrationSpct}
\alias{setRawSpct}
\alias{setCpsSpct}
\alias{setFilterSpct}
\alias{setSoluteSpct}
\alias{setReflectorSpct}
\alias{setObjectSpct}
\alias{setResponseSpct}
\alias{setSourceSpct}
\alias{setChromaSpct}
\title{Convert an R object into a spectrum object.}
\usage{
setGenericSpct(x, multiple.wl = 1L, idfactor = NULL)

setCalibrationSpct(
  x,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L,
  idfactor = NULL
)

setRawSpct(
  x,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L,
  idfactor = NULL
)

setCpsSpct(
  x,
  time.unit = "second",
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L,
  idfactor = NULL
)

setFilterSpct(
  x,
  Tfr.type = c("total", "internal"),
  Rfr.constant = NA_real_,
  thickness = NA_real_,
  attenuation.mode = NA_character_,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L,
  idfactor = NULL
)

setSoluteSpct(
  x,
  K.type = c("attenuation", "absorption", "scattering"),
  name = NA_character_,
  mass = NA_character_,
  formula = NA_character_,
  structure = grDevices::as.raster(matrix()),
  ID = NA_character_,
  solvent.name = NA_character_,
  solvent.ID = NA_character_,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L,
  idfactor = NULL
)

setReflectorSpct(
  x,
  Rfr.type = c("total", "specular"),
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L,
  idfactor = NULL
)

setObjectSpct(
  x,
  Tfr.type = c("total", "internal"),
  Rfr.type = c("total", "specular"),
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L,
  idfactor = NULL
)

setResponseSpct(
  x,
  time.unit = "second",
  response.type = "response",
  multiple.wl = 1L,
  idfactor = NULL
)

setSourceSpct(
  x,
  time.unit = "second",
  bswf.used = c("none", "unknown"),
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L,
  idfactor = NULL
)

setChromaSpct(x, multiple.wl = 1L, idfactor = NULL)
}
\arguments{
\item{x}{data.frame, list or generic_spct and derived classes}

\item{multiple.wl}{numeric Maximum number of repeated \code{w.length} entries
with same value.}

\item{idfactor}{character Name of factor distinguishing multiple spectra when
stored longitudinally (required if \code{mulitple.wl} > 1).}

\item{strict.range}{logical Flag indicating whether off-range values result
in an error instead of a warning.}

\item{time.unit}{character string indicating the time unit used for spectral
irradiance or exposure (\code{"second"}, \code{"day"} or \code{"exposure"})
or an object of class duration as defined in package lubridate.}

\item{Tfr.type}{character Either "total" or "internal".}

\item{Rfr.constant}{numeric The value of the reflection factor [\eqn{/1}].}

\item{thickness}{numeric The thickness of the material.}

\item{attenuation.mode}{character One of \code{"reflection"},
\code{"absorption"} or \code{"mixed"}.}

\item{K.type}{character A string, either "attenuation", "absorption" or
"scattering".}

\item{name, solvent.name}{character The names of the substance and of the
solvent. A named character vector, with member names such as "IUPAC" for
the authority.}

\item{mass}{numeric The mass in Dalton (Da = g/mol).}

\item{formula}{character The molecular formula.}

\item{structure}{raster A bitmap of the structure.}

\item{ID, solvent.ID}{character The IDs of the substance and of the solvent. A
named character vector, with member names such as "ChemSpider" or "PubChen"
for the authority.}

\item{Rfr.type}{character A string, either "total" or "specular".}

\item{response.type}{a character string, either \code{"response"} or \code{"action"}.}

\item{bswf.used}{character A string, either \code{"none"} or the name of a
BSWF. (Users seldom need to change the default, as this metadata value
is in normal use set by operators or functions that apply a BSWF.)}
}
\value{
x
}
\description{
Sets the class attribute of a data.frame or an object of a derived
class to "generic_spct".
}
\details{
This method alters \code{x} itself by reference and in addition
  returns the modified \code{x} invisibly. The wavelength values and data are
  checked for validity and out-of-range values trigger warnings. These checks
  are done during construction by means of the matching
  \code{\link{check_spct}} methods, unless checks have been disabled by
  setting the corresponding option (see \code{\link{enable_check_spct}}).
}
\section{Functions}{
\itemize{
\item \code{setCalibrationSpct()}: Set class of a an object to "calibration_spct".

\item \code{setRawSpct()}: Set class of a an object to "raw_spct".

\item \code{setCpsSpct()}: Set class of a an object to "cps_spct".

\item \code{setFilterSpct()}: Set class of an object to "filter_spct".

\item \code{setSoluteSpct()}: Set class of an object to "solute_spct".

\item \code{setReflectorSpct()}: Set class of a an object to "reflector_spct".

\item \code{setObjectSpct()}: Set class of an object to "object_spct".

\item \code{setResponseSpct()}: Set class of an object to "response_spct".

\item \code{setSourceSpct()}: Set class of an object to "source_spct".

\item \code{setChromaSpct()}: Set class of an object to "chroma_spct".

}}
\note{
\code{"internal"} \strong{transmittance} is defined as the
  transmittance of the material body itself, while \code{"total"}
  transmittance includes the effects of surface reflectance on the amount of
  light transmitted. For non-diffusing materials like glass an approximate
  \code{Rfr.constant} value can be used to inter-convert total and internal
  transmittance values. Use \code{NA} if the the mode is not known, or not
  applicable, e.g., for materials subject to internal scattering. The
  validity of computations related to thickness of the material or length of
  the light path depends on the availability and accuracy of the metadata.

Particles in suspension unlike disolved \strong{solutes} scatter light.
  Thus two different processes can attenuate light in liquid media:
  absorption and scattering. Coefficients of attenuation are always based on
  measurements of internal absorbance or internal transmittance. In practice
  this is achieved by using as reference pure solvent in a vessel, such as a
  spectrometer cuvette, called \emph{blank}. The measurement of the blank is
  done sequentially, before or after the \emph{sample} of interest in single
  beam spectrophotometers and concurrently in double beam spectrophotometers.
  \code{K.type} describes the process of attenuation: \code{"attenuation"},
  \code{"absorption"} or \code{"scattering"}, with \code{"attenuation"} used
  for cases of mixed modes of attenuation. Set \code{K.type = NA} if not
  available or unknown, or not applicable.

\code{"specular"} \strong{reflectance} is defined as that measured by
  collecting the light reflected by the surface at the \dQuote{mirror} of the
  angle of incidence; i.e., using a probe with a narrow angle of aperture.
  Usually measured close to normal angle of incidence. \code{"total"}
  \strong{reflectance} is defined as that measured by collecting all the
  light reflected by the surface; i.e., using an integrating sphere. In a
  mirror, reflectance is mostly specular, while on the white surface of a
  sheet of paper scattering predominates. In the first case the value for
  total reflectance is not much more than for specular reflectance, while in
  the second case the difference is much larger as the "specular" component
  is much smaller.
}
\section{Warning!}{
 Not entering metadata when creating an object will limit
  the available operations!
}

\examples{
my.df <- data.frame(w.length = 300:309, s.e.irrad = rep(100, 10))
is.source_spct(my.df)
setSourceSpct(my.df)
is.source_spct(my.df)

}
\seealso{
Other set and unset spectral class functions: 
\code{\link{rmDerivedSpct}()}
}
\concept{set and unset spectral class functions}
