% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.utils.r
\name{uncollect2spct}
\alias{uncollect2spct}
\alias{uncollect2spct.default}
\alias{uncollect2spct.generic_mspct}
\title{Extract all members from a collection}
\usage{
uncollect2spct(x, ...)

\method{uncollect2spct}{default}(x, ...)

\method{uncollect2spct}{generic_mspct}(
  x,
  name.tag = ".spct",
  ignore.case = FALSE,
  check.names = TRUE,
  check.overwrite = TRUE,
  ...
)
}
\arguments{
\item{x}{An R object}

\item{...}{additional named arguments passed down to \code{f}.}

\item{name.tag}{character. A string used as tag for the names of the objects.
If of length zero, names of members are used as named of objects. Otherwise
the tag is appended, unless already present in the member name.}

\item{ignore.case}{logical. If FALSE, the pattern matching used for \code{name.tag} is
case sensitive and if TRUE, case is ignored during matching.}

\item{check.names}{logical. If TRUE then the names of the objects created are
checked to ensure that they are syntactically valid variable names and
unique. If necessary they are adjusted (by make.names) so that they are,
and if FALSE names are used as is.}

\item{check.overwrite}{logical. If TRUE trigger an error if an exisitng
object would be overwritten, and if FALSE silently overwrite objects.}
}
\value{
Utility used for its side effects, invisibly returns a character
  vector with the names of the objects created.
}
\description{
Extract all members from a collection into separate objects in the parent
frame of the call.
}
\section{Methods (by class)}{
\itemize{
\item \code{uncollect2spct(default)}: Default for generic function

\item \code{uncollect2spct(generic_mspct)}: 

}}
\examples{

my.mscpt <- source_mspct(list(sun1.spct = sun.spct, sun2.spct = sun.spct))
uncollect2spct(my.mscpt)
ls(pattern = "*.spct")

}
\seealso{
Other experimental utility functions: 
\code{\link{collect2mspct}()},
\code{\link{drop_user_cols}()},
\code{\link{thin_wl}()}
}
\concept{experimental utility functions}
