% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.summary.r, R/spct.summaries.r
\name{summary}
\alias{summary}
\alias{summary.generic_mspct}
\alias{summary.generic_spct}
\title{Summary of a collection of spectra}
\usage{
\method{summary}{generic_mspct}(
  object,
  maxsum = 7,
  digits = max(3, getOption("digits") - 3),
  idx = "spct.idx",
  which.metadata = NULL,
  ...
)

\method{summary}{generic_spct}(object, maxsum = 7, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{object}{An object of one of the spectral classes for which a summary is
desired}

\item{maxsum}{integer Indicates how many levels should be shown for factors.}

\item{digits}{integer Used for number formatting with \code{\link{format}()}.}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}

\item{which.metadata}{character vector Names of attributes to retrieve, or
"none" or "all".}

\item{...}{additional arguments affecting the summary produced, ignored in
current version}
}
\value{
A summary object matching the class of \code{object}.

A summary object matching the class of \code{object}.
}
\description{
Method of generic function summary for objects of spectral collection
classes.

Methods of generic function summary for objects of spectral classes.
}
\examples{
summary(sun.spct)

summary(sun.spct)

}
