% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waveband.ratio.r
\name{waveband_ratio}
\alias{waveband_ratio}
\title{Photon or energy ratio}
\usage{
waveband_ratio(
  w.length,
  s.irrad,
  w.band.num = NULL,
  w.band.denom = NULL,
  unit.out.num = NULL,
  unit.out.denom = unit.out.num,
  unit.in = "energy",
  check.spectrum = TRUE,
  use.cached.mult = FALSE,
  use.hinges = getOption("photobiology.use.hinges", default = NULL)
)
}
\arguments{
\item{w.length}{numeric Vector of wavelengths (nm)}

\item{s.irrad}{numeric vector of spectral (energy or photon) irradiances (W
m-2 nm-1) or (mol s-1 m-2 nm-1).}

\item{w.band.num}{waveband object used to compute the numerator of the ratio.}

\item{w.band.denom}{waveband object used to compute the denominator of the
ratio.}

\item{unit.out.num}{character Allowed values "energy", and "photon", or its
alias "quantum".}

\item{unit.out.denom}{character Allowed values "energy", and "photon", or its
alias "quantum".}

\item{unit.in}{character Allowed values "energy", and "photon", or its alias
"quantum".}

\item{check.spectrum}{logical Flag indicating whether to sanity check input
data, default is TRUE.}

\item{use.cached.mult}{logical Flag indicating whether multiplier values
should be cached between calls.}

\item{use.hinges}{logical Flag indicating whether to insert "hinges" into the
spectral data before integration so as to reduce interpolation errors at
the boundaries of the wavebands.}
}
\value{
a single numeric value giving the ratio
}
\description{
This function gives the (energy or photon) irradiance ratio between two given
wavebands of a radiation spectrum.
}
\note{
The default for both \code{w.band} parameters is a waveband covering
  the whole range of \code{w.length}. From version 9.19 onwards use of this
  default does not trigger a warning, but instead is used silently.
}
\examples{
# photon:photon ratio
with(sun.data,
     waveband_ratio(w.length, s.e.irrad,
                    new_waveband(400,500),
                    new_waveband(400,700), "photon"))
# energy:energy ratio
with(sun.data,
     waveband_ratio(w.length, s.e.irrad,
                    new_waveband(400,500),
                    new_waveband(400,700), "energy"))
# energy:photon ratio
with(sun.data,
     waveband_ratio(w.length, s.e.irrad,
                    new_waveband(400,700),
                    new_waveband(400,700),
                    "energy", "photon"))
# photon:photon ratio waveband : whole spectrum
with(sun.data,
     waveband_ratio(w.length, s.e.irrad,
                    new_waveband(400,500),
                    unit.out.num="photon"))
# photon:photon ratio of whole spectrum should be equal to 1.0
with(sun.data,
     waveband_ratio(w.length, s.e.irrad,
     unit.out.num="photon"))

}
