% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sun.data.r
\docType{data}
\name{sun_evening.spct}
\alias{sun_evening.spct}
\alias{sun_evening.mspct}
\title{Time series of solar spectral irradiance (measured)}
\format{
A \code{source_spct} object and a \code{source_mspct} object.

An object of class \code{source_mspct} (inherits from \code{generic_mspct}, \code{list}) with 5 rows and 1 columns.
}
\usage{
sun_evening.spct

sun_evening.mspct
}
\description{
Two data objects containing containing the same time series of five spectra.
Values measured in Viikki, Helsinki, under nearly clear sky in a summer
evening.
}
\details{
The variables are as follows:

\itemize{ \item w.length (nm), range 290 to 1000 nm. \item s.e.irrad (J d-1
m-2 nm-1) \item s.q.irrad (mol d-1 m-2 nm-1) }
}
\examples{
summary(sun_evening.mspct)
colnames(sun_evening.spct)

}
\seealso{
Other Spectral data examples: 
\code{\link{A.illuminant.spct}},
\code{\link{D50.illuminant.spct}},
\code{\link{D65.illuminant.spct}},
\code{\link{Ler_leaf.spct}},
\code{\link{black_body.spct}},
\code{\link{ccd.spct}},
\code{\link{clear.spct}},
\code{\link{filter_cps.mspct}},
\code{\link{green_leaf.spct}},
\code{\link{phenylalanine.spct}},
\code{\link{photodiode.spct}},
\code{\link{sun.spct}},
\code{\link{sun_daily.spct}},
\code{\link{two_filters.spct}},
\code{\link{two_sensors.mspct}},
\code{\link{water.spct}},
\code{\link{white_led.source_spct}}
}
\author{
Pedro J. Aphalo (data)
}
\concept{Spectral data examples}
\keyword{datasets}
