% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cieillum.data.r
\docType{data}
\name{D50.illuminant.spct}
\alias{D50.illuminant.spct}
\title{CIE D50 illuminant data}
\format{
A source spectrum with 531 rows and 2 variables

\itemize{ \item w.length (nm) \item s.e.irrad (rel. units) }
}
\usage{
D50.illuminant.spct
}
\description{
A dataset containing wavelengths at a 5 nm interval (300 nm to
  830 nm) and the corresponding spectral energy irradiance normalized to 1 at
  560 nm. Spectrum approximates the midday solar spectrum at middle latitude
  as 'corresponds' to the white point of a black body a 6504 K. Original data
  from CIE downloaded on 2024-11-30 The variables are as follows:
}
\note{
This and other CIE illuminant spectra can be downloaded from
  \url{https://cie.co.at/data-tables} as .CSV files.
}
\examples{
D50.illuminant.spct

}
\references{
CIE 2022, Relative spectral power distributions of CIE standard
illuminants A, D65 and D50 (wavelengths in standard air) (data table),
International Commission on Illumination (CIE), Vienna, Austria,
\doi{10.25039/CIE.DS.etgmuqt5}.
}
\seealso{
Other Spectral data examples: 
\code{\link{A.illuminant.spct}},
\code{\link{D65.illuminant.spct}},
\code{\link{Ler_leaf.spct}},
\code{\link{black_body.spct}},
\code{\link{ccd.spct}},
\code{\link{clear.spct}},
\code{\link{filter_cps.mspct}},
\code{\link{green_leaf.spct}},
\code{\link{phenylalanine.spct}},
\code{\link{photodiode.spct}},
\code{\link{sun.spct}},
\code{\link{sun_daily.spct}},
\code{\link{sun_evening.spct}},
\code{\link{two_filters.spct}},
\code{\link{two_sensors.mspct}},
\code{\link{water.spct}},
\code{\link{white_led.source_spct}}
}
\author{
CIE
}
\concept{Spectral data examples}
\keyword{datasets}
