% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.peaks.r
\name{valleys}
\alias{valleys}
\alias{valleys.default}
\alias{valleys.numeric}
\alias{valleys.data.frame}
\alias{valleys.generic_spct}
\alias{valleys.source_spct}
\alias{valleys.response_spct}
\alias{valleys.filter_spct}
\alias{valleys.reflector_spct}
\alias{valleys.solute_spct}
\alias{valleys.cps_spct}
\alias{valleys.raw_spct}
\alias{valleys.generic_mspct}
\alias{valleys.source_mspct}
\alias{valleys.response_mspct}
\alias{valleys.filter_mspct}
\alias{valleys.reflector_mspct}
\alias{valleys.solute_mspct}
\alias{valleys.cps_mspct}
\alias{valleys.raw_mspct}
\title{Valleys or local minima}
\usage{
valleys(
  x,
  span,
  global.threshold,
  local.threshold,
  local.reference,
  threshold.range,
  strict,
  ...
)

\method{valleys}{default}(
  x,
  span,
  global.threshold = NA,
  local.threshold = NA,
  local.reference = NA,
  threshold.range = NA,
  strict,
  ...
)

\method{valleys}{numeric}(
  x,
  span = 5,
  global.threshold = 0,
  local.threshold = 0,
  local.reference = "minimum",
  threshold.range = NULL,
  strict = TRUE,
  na.rm = FALSE,
  ...
)

\method{valleys}{data.frame}(
  x,
  span = 5,
  global.threshold = 0,
  local.threshold = 0,
  local.reference = "minimum",
  threshold.range = NULL,
  strict = TRUE,
  na.rm = FALSE,
  x.var.name = NULL,
  y.var.name = NULL,
  var.name = y.var.name,
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{valleys}{generic_spct}(
  x,
  span = 5,
  global.threshold = 0,
  local.threshold = 0,
  local.reference = "minimum",
  threshold.range = NULL,
  strict = TRUE,
  na.rm = FALSE,
  var.name = NULL,
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{valleys}{source_spct}(
  x,
  span = 5,
  global.threshold = 0,
  local.threshold = 0,
  local.reference = "minimum",
  threshold.range = NULL,
  strict = TRUE,
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{valleys}{response_spct}(
  x,
  span = 5,
  global.threshold = 0,
  local.threshold = 0,
  local.reference = "minimum",
  threshold.range = NULL,
  strict = TRUE,
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{valleys}{filter_spct}(
  x,
  span = 5,
  global.threshold = 0,
  local.threshold = 0,
  local.reference = "minimum",
  threshold.range = NULL,
  strict = TRUE,
  na.rm = FALSE,
  filter.qty = getOption("photobiology.filter.qty", default = "transmittance"),
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{valleys}{reflector_spct}(
  x,
  span = 5,
  global.threshold = 0,
  local.threshold = 0,
  local.reference = "minimum",
  threshold.range = NULL,
  strict = TRUE,
  na.rm = FALSE,
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{valleys}{solute_spct}(
  x,
  span = 5,
  global.threshold = 0,
  local.threshold = 0,
  local.reference = "minimum",
  threshold.range = NULL,
  strict = TRUE,
  na.rm = FALSE,
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{valleys}{cps_spct}(
  x,
  span = 5,
  global.threshold = 0,
  local.threshold = 0,
  local.reference = "minimum",
  threshold.range = NULL,
  strict = TRUE,
  na.rm = FALSE,
  var.name = "cps",
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{valleys}{raw_spct}(
  x,
  span = 5,
  global.threshold = 0,
  local.threshold = 0,
  local.reference = "minimum",
  threshold.range = NULL,
  strict = TRUE,
  na.rm = FALSE,
  var.name = "counts",
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{valleys}{generic_mspct}(
  x,
  span = 5,
  global.threshold = 0,
  local.threshold = 0,
  local.reference = "minimum",
  threshold.range = NULL,
  strict = TRUE,
  na.rm = FALSE,
  var.name = NULL,
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{valleys}{source_mspct}(
  x,
  span = 5,
  global.threshold = 0,
  local.threshold = 0,
  local.reference = "minimum",
  threshold.range = NULL,
  strict = TRUE,
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{valleys}{response_mspct}(
  x,
  span = 5,
  global.threshold = 0,
  local.threshold = 0,
  local.reference = "minimum",
  threshold.range = NULL,
  strict = TRUE,
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{valleys}{filter_mspct}(
  x,
  span = 5,
  global.threshold = 0,
  local.threshold = 0,
  local.reference = "minimum",
  threshold.range = NULL,
  strict = TRUE,
  na.rm = FALSE,
  filter.qty = getOption("photobiology.filter.qty", default = "transmittance"),
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{valleys}{reflector_mspct}(
  x,
  span = 5,
  global.threshold = 0,
  local.threshold = 0,
  local.reference = "minimum",
  threshold.range = NULL,
  strict = TRUE,
  na.rm = FALSE,
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{valleys}{solute_mspct}(
  x,
  span = 5,
  global.threshold = 0,
  local.threshold = 0,
  local.reference = "minimum",
  threshold.range = NULL,
  strict = TRUE,
  na.rm = FALSE,
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{valleys}{cps_mspct}(
  x,
  span = 5,
  global.threshold = 0,
  local.threshold = 0,
  local.reference = "minimum",
  threshold.range = NULL,
  strict = TRUE,
  na.rm = FALSE,
  var.name = "cps",
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{valleys}{raw_mspct}(
  x,
  span = 5,
  global.threshold = 0,
  local.threshold = 0,
  local.reference = "minimum",
  threshold.range = NULL,
  strict = TRUE,
  na.rm = FALSE,
  var.name = "counts",
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)
}
\arguments{
\item{x}{numeric vector. Hint: to find valleys, change the sign of the
argument with the unary operator \code{-}.}

\item{span}{odd integer A peak is defined as an element in a sequence which
is greater than all other elements within a moving window of width
\code{span} centred at that element. The default value is 5, meaning that a
peak is taller than its four nearest neighbours. \code{span = NULL} extends
the span to the whole length of \code{x}.}

\item{global.threshold}{numeric A value between 0.0 and 1.0,
relative to \code{threshold.range} indicating the \emph{global} height
(depth) threshold below which peaks (valleys) will be ignored, or a
negative value, between 0.0 and -1.0 indicating the \emph{global} height
(depth) threshold above which peaks (valleys) will be ignored. If
\code{threshold.range = 0} or the value passed as argument belongs to class
\code{"AsIs"} the value is interpreted as an absolute value expressed in
data units.}

\item{local.threshold}{numeric A value between 0.0 and 1.0, relative to
\code{threshold.range}, indicating the
\emph{within-window} height (depth) threshold below which peaks (valleys)
will be ignored.  If \code{threshold.range = 0} or the value passed
as argument belongs to class \code{"AsIs"} the value is interpreted as an
absolute value expressed in data units.}

\item{local.reference}{character One of \code{"minimum"} (eqv.
\code{"maximum"}) or \code{"median"}. The reference used to assess the
height of the peak, either the minimum (maximum) value within the window or
the median of all values in the window.}

\item{threshold.range}{numeric vector of length 2 or a longer vector or list
on which a call to \code{range()} returns a numeric vector of length 2. If
\code{NULL}, the default, \code{range(x)} is used.}

\item{strict}{logical flag: if TRUE, an element must be strictly greater than
all other values in its window to be considered a peak. Default: TRUE.}

\item{...}{ignored}

\item{na.rm}{logical indicating whether \code{NA} values should be stripped
before searching for peaks.}

\item{var.name, x.var.name, y.var.name}{character Name of column where to look
for valleys.}

\item{refine.wl}{logical Flag indicating if valley location should be refined by
fitting a function.}

\item{method}{character String with the name of a method. Currently only
spline interpolation is implemented.}

\item{unit.out}{character One of "energy" or "photon"}

\item{filter.qty}{character One of "transmittance" or "absorbance"}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
A subset of \code{x} with rows corresponding to local minima or
  global minimum.
}
\description{
Function that returns a subset of an R object with observations corresponding
to local maxima.
}
\details{
Function \code{find_peaks} is a wrapper built onto function
  \code{\link[splus2R]{peaks}} from \pkg{splus2R}, adds support for peak
  height thresholds and handles \code{span = NULL} and non-finite (including
  NA) values differently than \code{splus2R::peaks}. Instead of giving an
  error when \code{na.rm = FALSE} and \code{x} contains \code{NA} values,
  \code{NA} values are replaced with the smallest finite value in \code{x}.
  \code{span = NULL} is treated as a special case and selects \code{max(x)}.
  Two tests are optional, one based on the absolute height of the peaks
  (\code{global.threshold}) and another based on the height of the peaks
  compared to other values within the window of width equal to \code{span}
  (\code{local.threshold}). The reference value used within each window
  containing a peak is given by \code{local.reference}. Parameter
  \code{threshold.range} determines how the values passed as argument to
  \code{global.threshold} and \code{local.threshold} are scaled. The default,
  \code{NULL} uses the range of \code{x}. Thresholds for ignoring too small
  peaks are applied after peaks are searched for, and negative threshold
  values can in some cases result in no peaks being returned.

  While function \code{find_peaks} accepts as input a \code{numeric} vector
  and returns a \code{logical} vector, methods \code{peaks} and
  \code{valleys} accept as input different R objects, including spectra and
  collections of spectra and return a subset of the object. These methods
  are implemented using calls to functions \code{find_peaks} and
  \code{\link{fit_peaks}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{valleys(default)}: Default returning always NA.

\item \code{valleys(numeric)}: Default function usable on numeric vectors.

\item \code{valleys(data.frame)}: Method for "data.frame" objects.

\item \code{valleys(generic_spct)}: Method for "generic_spct" objects.

\item \code{valleys(source_spct)}: Method for "source_spct" objects.

\item \code{valleys(response_spct)}: Method for "response_spct" objects.

\item \code{valleys(filter_spct)}: Method for "filter_spct" objects.

\item \code{valleys(reflector_spct)}: Method for "reflector_spct".

\item \code{valleys(solute_spct)}: Method for "solute_spct" objects.

\item \code{valleys(cps_spct)}: Method for "cps_spct" objects.

\item \code{valleys(raw_spct)}: Method for "raw_spct" objects.

\item \code{valleys(generic_mspct)}: Method for "generic_mspct" objects.

\item \code{valleys(source_mspct)}: Method for "source_mspct" objects.

\item \code{valleys(response_mspct)}: Method for "cps_mspct" objects.

\item \code{valleys(filter_mspct)}: Method for "filter_mspct" objects.

\item \code{valleys(reflector_mspct)}: Method for "reflector_mspct" objects.

\item \code{valleys(solute_mspct)}: Method for "solute_mspct" objects.

\item \code{valleys(cps_mspct)}: Method for "cps_mspct" objects.

\item \code{valleys(raw_mspct)}: Method for "raw_mspct" objects.

}}
\note{
The default for parameter \code{strict} is \code{FALSE} in functions
  \code{peaks()} and \code{find_peaks()}, as in \code{stat_peaks()} and in
  \code{stat_valleys()}, while the default in \code{\link[splus2R]{peaks}}
  is \code{strict = TRUE}.
}
\examples{
# default span = 5
valleys(sun.spct)
# global minimum
valleys(sun.spct, span = NULL)
valleys(sun.spct, span = NULL, strict = FALSE)
# a wider window
valleys(sun.spct, span = 51)
# global threshold relative to the range of s.e.irrad values
valleys(sun.spct, global.threshold = -0.2)
# global threshold in actual s.e.irrad values
valleys(sun.spct, global.threshold = -0.2, threshold.range = c(0, 1))
# local threshold  relative to the range of s.e.irrad values
valleys(sun.spct, local.threshold = 0.1)
# local threshold in actual s.e.irrad values
valleys(sun.spct, local.threshold = 0.1, threshold.range = c(0, 1))
# local threshold  relative to the range of s.e.irrad values, using window
# median instead of window minimum
valleys(sun.spct, local.threshold = 0.1, local.reference = "median")
# minimum, the default.
valleys(sun.spct, local.threshold = 0.1, local.reference = "minimum")

valleys(sun.spct)

}
\seealso{
Other peaks and valleys functions: 
\code{\link{find_peaks}()},
\code{\link{find_spikes}()},
\code{\link{get_peaks}()},
\code{\link{peaks}()},
\code{\link{replace_bad_pixs}()},
\code{\link{spikes}()},
\code{\link{wls_at_target}()}
}
\concept{peaks and valleys functions}
