% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sun.calc.r
\name{solar_time}
\alias{solar_time}
\title{Local solar time}
\usage{
solar_time(time = lubridate::now(), geocode = data.frame(lon = 0, lat =
  51.5, address = "Greenwich"), unit.out = "time")
}
\arguments{
\item{time}{POSIXct Time, any valid time zone (TZ) is allowed, default is
current time}

\item{geocode}{data frame with variables lon and lat as numeric values
(degrees).}

\item{unit.out}{charater string, One of "datetime", "hour", "minute", or "second".}
}
\value{
For \code{solar_time()} numeric value in seconds from midnight but
  with an additional class attribute "solar.time".
}
\description{
\code{solar_time} computes from a time and geocode, the time of day expressed
in seconds since midnight. \code{solar_date} returns the same instant in time
as a date-time object. Solar time is useful when we want to plot data
according to the local solar time of day, irrespective of the date. Solar
date is useful when we want to plot a time series streching for several days
using the local solar time but distinguishing between days.
}
\note{
The algorithm is approximate, it calculates the difference between
  local solar noon and noon in the time zone of \code{time} and uses this
  value for the whole day when converting times into solar time. Days are not
  exactly 24 h long. Between succesive days the shift is only a few seconds,
  and this leads to a small jump at midnight.
}
\section{Warning!}{

  Returned values are computed based on the time zone of the argument for
  parameter time. In the case of solar time, this timezone does not affect
  the result. However, in the case of solar dates the date part may be be
  off by one day, if the time zone does not match the coordinates of the
  goecode value provided as argument.
}
\examples{
# BA.geocode <- ggmap::geocode("Buenos Aires, Argentina")
BA.geocode <- data.frame(lon = -58.38156, lat = -34.60368)
sol_t <- solar_time(lubridate::dmy_hms("21/06/2016 10:00:00", tz = "UTC"),
                    BA.geocode)
sol_t
class(sol_t)

sol_d <- solar_time(lubridate::dmy_hms("21/06/2016 10:00:00", tz = "UTC"),
                    BA.geocode,
                    unit.out = "datetime")
sol_d
class(sol_d)

}
\seealso{
Other astronomy related functions: \code{\link{day_night}},
  \code{\link{format.solar_time}},
  \code{\link{is.solar_time}},
  \code{\link{print.solar_time}}, \code{\link{sun_angles}}
}

