% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{trimInstrSettings}
\alias{trimInstrSettings}
\title{Trim the "instr.settings" attribute}
\usage{
trimInstrSettings(x, fields = "*")
}
\arguments{
\item{x}{a generic_spct object}

\item{fields}{a character vector with the names of the fields to keep,
or if first member is `"-"`, the names of fields to delete; "*" as
first member of the vector makes the function a no-op, leaving the spectrum
object unaltered.}
}
\value{
x
}
\description{
Function to trim the "instr.settings" attribute of an existing generic_spct
object, by discarding some fields.
}
\note{
This function alters x itself by reference and in addition
  returns x invisibly. If x is not a generic_spct object, x is not
  modified.
}
\seealso{
Other measurement metadata functions: \code{\link{getInstrDesc}},
  \code{\link{getInstrSettings}},
  \code{\link{getWhatMeasured}},
  \code{\link{getWhenMeasured}},
  \code{\link{getWhereMeasured}},
  \code{\link{isValidInstrDesc}},
  \code{\link{isValidInstrSettings}},
  \code{\link{setInstrDesc}},
  \code{\link{setInstrSettings}},
  \code{\link{setWhatMeasured}},
  \code{\link{setWhenMeasured}},
  \code{\link{setWhereMeasured}},
  \code{\link{trimInstrDesc}}
}
