% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energy.irradiance.R
\name{energy_irradiance}
\alias{energy_irradiance}
\title{Calculate (energy) irradiance from spectral irradiance}
\usage{
energy_irradiance(w.length, s.irrad, w.band = NULL, unit.in = "energy",
  check.spectrum = TRUE, use.cached.mult = FALSE,
  use.hinges = getOption("photobiology.use.hinges", default = NULL))
}
\arguments{
\item{w.length}{numeric array of wavelength (nm)}

\item{s.irrad}{numeric array of spectral irradiances, by default as energy (W
m-2 nm-1)}

\item{w.band}{waveband}

\item{unit.in}{a character Allowed values "photon" or "energy", default is
"energy"}

\item{check.spectrum}{logical Flag indicating whether to sanity check input
data, default is TRUE}

\item{use.cached.mult}{logical Flag indicating whether multiplier values
should be cached between calls}

\item{use.hinges}{logical Flag indicating whether to use hinges to reduce
interpolation errors}
}
\value{
A single numeric value with no change in scale factor: [W m-2 nm-1]
  -> [W m-2]
}
\description{
This function gives the energy irradiance for a given waveband of a radiation
spectrum, optionally applies a BSWF.
}
\examples{
with(sun.data, energy_irradiance(w.length, s.e.irrad))
with(sun.data, energy_irradiance(w.length, s.e.irrad, new_waveband(400,700)))

}
\seealso{
Other irradiance functions: \code{\link{e_fluence}},
  \code{\link{e_irrad}}, \code{\link{fluence}},
  \code{\link{irradiance}}, \code{\link{irrad}},
  \code{\link{photon_irradiance}}, \code{\link{q_fluence}},
  \code{\link{q_irrad}}
}
