% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.ratios.R
\name{eq_ratio}
\alias{eq_ratio}
\alias{eq_ratio.default}
\alias{eq_ratio.source_spct}
\alias{eq_ratio.source_mspct}
\title{Energy:photon ratio}
\usage{
eq_ratio(spct, w.band, wb.trim, use.cached.mult, use.hinges, ...)

\method{eq_ratio}{default}(spct, w.band, wb.trim, use.cached.mult, use.hinges,
  ...)

\method{eq_ratio}{source_spct}(spct, w.band = NULL,
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.cached.mult = FALSE,
  use.hinges = getOption("photobiology.use.hinges"), ...)

\method{eq_ratio}{source_mspct}(spct, w.band = NULL,
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.cached.mult = FALSE,
  use.hinges = getOption("photobiology.use.hinges"), ..., attr2tb = NULL,
  idx = !is.null(names(spct)))
}
\arguments{
\item{spct}{source_spct}

\item{w.band}{waveband or list of waveband objects}

\item{wb.trim}{logical if TRUE wavebands crossing spectral data boundaries
are trimmed, if FALSE, they are discarded}

\item{use.cached.mult}{logical Flag telling whether multiplier values should
be cached between calls}

\item{use.hinges}{logical Flag telling whether to use hinges to reduce
interpolation errors}

\item{...}{other arguments (possibly ignored)}

\item{attr2tb}{character vector, see \code{\link{add_attr2tb}} for the syntax for \code{attr2tb} passed as is to formal parameter \code{col.names}.}

\item{idx}{logical whether to add a column with the names of the elements of spct}
}
\value{
Computed values are ratios between energy irradiance and photon
  irradiance for a given waveband. A named \code{numeric} vector in the case
  of methods for individual spectra, with one value for each \code{waveband}
  passed to parameter \code{w.band}. A \code{data.frame} in the case of
  collections of spectra, containing one column for each \code{waveband}
  object, an index column with the names of the spectra, and optionally
  additional columns with metadata values retrieved from the attributes of
  the member spectra.

  By default values are only integrated, but depending on the argument passed
  to parameter \code{quantity} they can be re-expressed as relative fractions
  or percentages. In the case of vector output, \code{names} attribute is set
  to the name of the corresponding waveband unless a named list is supplied
  in which case the names of the list members are used, with "e:q" prepended.
  Units [J mol-1].
}
\description{
This function returns the energy to mole of photons ratio for each waveband and a
light source spectrum.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default for generic function

\item \code{source_spct}: Method for \code{source_spct} objects

\item \code{source_mspct}: Calculates energy:photon from a \code{source_mspct}
object.
}}

\note{
The last two parameters control speed optimizations. The defaults
  should be suitable in mosts cases. If you will use repeatedly the same SWFs
  on many spectra measured at exactly the same wavelengths you may obtain
  some speed up by setting \code{use.cached.mult=TRUE}. However, be aware
  that you are responsible for ensuring that the wavelengths are the same in
  each call, as the only test done is for the length of the \code{w.length}
  vector.
}
\examples{
eq_ratio(sun.spct, new_waveband(400,700))

}
\seealso{
Other photon and energy ratio functions: \code{\link{e_ratio}},
  \code{\link{energy_ratio}}, \code{\link{photon_ratio}},
  \code{\link{photons_energy_ratio}},
  \code{\link{q_ratio}}, \code{\link{qe_ratio}}
}
