% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.normalize.r
\name{normalize}
\alias{normalize}
\alias{normalize.default}
\alias{normalize.source_spct}
\alias{normalize.response_spct}
\alias{normalize.filter_spct}
\alias{normalize.reflector_spct}
\alias{normalize.raw_spct}
\alias{normalize.cps_spct}
\alias{normalize.generic_spct}
\alias{normalize.source_mspct}
\alias{normalize.response_mspct}
\alias{normalize.filter_mspct}
\alias{normalize.reflector_mspct}
\alias{normalize.raw_mspct}
\alias{normalize.cps_mspct}
\title{Normalize spectral data}
\usage{
normalize(x, ...)

\method{normalize}{default}(x, ...)

\method{normalize}{source_spct}(x, ..., range = NULL, norm = "max",
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  na.rm = FALSE)

\method{normalize}{response_spct}(x, ..., range = NULL, norm = "max",
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  na.rm = FALSE)

\method{normalize}{filter_spct}(x, ..., range = NULL, norm = "max",
  qty.out = getOption("photobiology.filter.qty", default = "transmittance"),
  na.rm = FALSE)

\method{normalize}{reflector_spct}(x, ..., range = NULL, norm = "max",
  qty.out = NULL, na.rm = FALSE)

\method{normalize}{raw_spct}(x, ..., range = NULL, norm = "max",
  na.rm = FALSE)

\method{normalize}{cps_spct}(x, ..., range = NULL, norm = "max",
  na.rm = FALSE)

\method{normalize}{generic_spct}(x, ..., range = NULL, norm = "max",
  col.names, na.rm = FALSE)

\method{normalize}{source_mspct}(x, ..., range = NULL, norm = "max",
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  na.rm = FALSE, .parallel = FALSE, .paropts = NULL)

\method{normalize}{response_mspct}(x, ..., range = NULL, norm = "max",
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  na.rm = FALSE, .parallel = FALSE, .paropts = NULL)

\method{normalize}{filter_mspct}(x, ..., range = NULL, norm = "max",
  qty.out = getOption("photobiology.filter.qty", default = "transmittance"),
  na.rm = FALSE, .parallel = FALSE, .paropts = NULL)

\method{normalize}{reflector_mspct}(x, ..., range = x, norm = "max",
  qty.out = NULL, na.rm = FALSE, .parallel = FALSE, .paropts = NULL)

\method{normalize}{raw_mspct}(x, ..., range = x, norm = "max",
  na.rm = FALSE, .parallel = FALSE, .paropts = NULL)

\method{normalize}{cps_mspct}(x, ..., range = x, norm = "max",
  na.rm = FALSE, .parallel = FALSE, .paropts = NULL)
}
\arguments{
\item{x}{An R object}

\item{...}{not used in current version}

\item{range}{An R object on which \code{range()} returns a numeric vector of
length 2 with the limits of a range of wavelengths in nm, with min and max
wavelengths (nm) used to set boundaries for search for normalization.}

\item{norm}{numeric Normalization wavelength (nm) or character string "max",
or "min" for normalization at the corresponding wavelength.}

\item{unit.out}{character Allowed values "energy", and "photon",
or its alias "quantum"}

\item{na.rm}{logical indicating whether \code{NA} values should be stripped
before calculating the summary (e.g. "max") used for normalization.}

\item{qty.out}{character string  Allowed values are "transmittance", and
"absorbance" indicating on which quantity to apply the normalization.}

\item{col.names}{character vector containing the names of columns or
variables to which to apply the normalization.}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
A copy of \code{x}, with spectral data values normalized to one for
the criterion specified by the argument passed to \code{norm}.

A copy of \code{x} with the values of the spectral quantity rescaled
  to 1 at the normalization wavelength. If the normalization wavelength is
  not already present in \code{x}, it is added by interpolation---i.e. the
  returned value may be one row longer than \code{x}.
}
\description{
These functions return a spectral object of the same class as the one
supplied as argument but with the spectral data normalized to 1.o a certain
wavelength.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default for generic function

\item \code{source_spct}: Normalize a \code{source_spct} object.

\item \code{response_spct}: Normalize a response spectrum.

\item \code{filter_spct}: Normalize a filter spectrum.

\item \code{reflector_spct}: Normalize a reflector spectrum.

\item \code{raw_spct}: Normalize a raw spectrum.

\item \code{cps_spct}: Normalize a cps spectrum.

\item \code{generic_spct}: Normalize a raw spectrum.

\item \code{source_mspct}: Normalize the members of a source_mspct object.

\item \code{response_mspct}: Normalize the members of a response_mspct object.

\item \code{filter_mspct}: Normalize the members of a filter_mspct object.

\item \code{reflector_mspct}: Normalize the members of a reflector_mspct object.

\item \code{raw_mspct}: Normalize the members of a raw_mspct object.

\item \code{cps_mspct}: Normalize the members of a cps_mspct object.
}}

\note{
1) By default if \code{x} contains one or more \code{NA} values and the
  normalization is based on a summary quantity, the returned spectrum will
  contain only \code{NA} values. If \code{na.rm == TRUE} then the summary
  quantity will be calculated after striping \code{NA} values, and only the
  values that were \code{NA} in \code{x} will be {NA} values in the returned
  spectrum.
}
\examples{
normalize(sun.spct)
normalize(sun.spct, norm = "max")
normalize(sun.spct, norm = 400)

}
\seealso{
Other rescaling functions: \code{\link{fscale}},
  \code{\link{fshift}}, \code{\link{getNormalized}},
  \code{\link{is_normalized}}, \code{\link{is_scaled}},
  \code{\link{setNormalized}}, \code{\link{setScaled}}
}
