% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2qmol.multipliers.r
\name{e2qmol_multipliers}
\alias{e2qmol_multipliers}
\title{Calculate energy to quantum (mol) multipliers}
\usage{
e2qmol_multipliers(w.length)
}
\arguments{
\item{w.length}{numeric Vector of wavelengths (nm)}
}
\value{
A numeric vector of multipliers
}
\description{
Multipliers as a function of wavelength, for converting from energy to
photon (quantum) molar units.
}
\examples{
with(sun.data, e2qmol_multipliers(w.length))

}
\seealso{
Other quantity conversion functions: \code{\link{A2T}},
  \code{\link{T2Afr}}, \code{\link{T2A}},
  \code{\link{T2T}}, \code{\link{as_quantum}},
  \code{\link{e2quantum_multipliers}}, \code{\link{e2q}},
  \code{\link{q2e}}
}
\concept{quantity conversion functions}
