% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.irrad.r
\name{e_fluence}
\alias{e_fluence}
\alias{e_fluence.default}
\alias{e_fluence.source_spct}
\alias{e_fluence.source_mspct}
\title{Energy fluence}
\usage{
e_fluence(spct, w.band, exposure.time, scale.factor, wb.trim,
  use.cached.mult, use.hinges, allow.scaled, ...)

\method{e_fluence}{default}(spct, w.band, exposure.time, scale.factor,
  wb.trim, use.cached.mult, use.hinges, allow.scaled, ...)

\method{e_fluence}{source_spct}(spct, w.band = NULL, exposure.time,
  scale.factor = 1, wb.trim = getOption("photobiology.waveband.trim",
  default = TRUE),
  use.cached.mult = getOption("photobiology.use.cached.mult", default =
  FALSE), use.hinges = NULL, allow.scaled = FALSE, ...)

\method{e_fluence}{source_mspct}(spct, w.band = NULL, exposure.time,
  scale.factor = 1, wb.trim = getOption("photobiology.waveband.trim",
  default = TRUE),
  use.cached.mult = getOption("photobiology.use.cached.mult", default =
  FALSE), use.hinges = NULL, allow.scaled = FALSE, ...,
  attr2tb = NULL, idx = "spct.idx", .parallel = FALSE,
  .paropts = NULL)
}
\arguments{
\item{spct}{an R object}

\item{w.band}{a list of \code{waveband} objects or a \code{waveband} object}

\item{exposure.time}{lubridate::duration object.}

\item{scale.factor}{numeric vector of length 1, or length equal to that of
\code{w.band}. Numeric multiplier applied to returned values.}

\item{wb.trim}{logical if TRUE wavebands crossing spectral data boundaries
are trimmed, if FALSE, they are discarded}

\item{use.cached.mult}{logical indicating whether multiplier values should be
cached between calls}

\item{use.hinges}{logical Flag indicating whether to insert "hinges" into the
spectral data before integration so as to reduce interpolation errors at
the boundaries of the wavebands.}

\item{allow.scaled}{logical indicating whether scaled or normalized spectra
as argument to spct are flagged as an error}

\item{...}{other arguments (possibly ignored)}

\item{attr2tb}{character vector, see \code{\link{add_attr2tb}} for the syntax for \code{attr2tb} passed as is to formal parameter \code{col.names}.}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
One numeric value for each waveband with no change in scale factor,
  with name attribute set to the name of each waveband unless a named list is
  supplied in which case the names of the list elements are used. The
  exposure.time is copied to the output as an attribute. Units are as
  follows: (J) joules per exposure.
}
\description{
Energy fluence for one or more wavebands of a light source spectrum and a
duration of the exposure.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default for generic function

\item \code{source_spct}: Calculate energy fluence from a \code{source_spct}
object and the duration of the exposure.

\item \code{source_mspct}: Calculates energy fluence from a \code{source_mspct}
object.
}}

\note{
The last two parameters control speed optimizations. The defaults
  should be suitable in most cases. If you will use repeatedly the same SWFs
  on many spectra measured at exactly the same wavelengths you may obtain
  some speed up by setting \code{use.cached.mult=TRUE}. However, be aware
  that you are responsible for ensuring that the wavelengths are the same in
  each call, as the only test done is for the length of the \code{w.length}
  vector.
}
\examples{
library(lubridate)
e_fluence(sun.spct, w.band = waveband(c(400,700)),
          exposure.time = lubridate::duration(3, "minutes") )

}
\seealso{
Other irradiance functions: \code{\link{e_irrad}},
  \code{\link{fluence}}, \code{\link{irrad}},
  \code{\link{q_fluence}}, \code{\link{q_irrad}}
}
\concept{irradiance functions}
