% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meeus.r
\docType{data}
\name{calendar_change}
\alias{calendar_change}
\alias{julian_day}
\alias{julian_day_fast}
\alias{julian_century}
\alias{geom_mean_lon_sun}
\alias{geom_mean_anom_sun}
\alias{eccent_earth_orbit}
\alias{sun_eq_of_ctr}
\alias{sun_rad_vector}
\alias{sun_app_lon}
\alias{mean_obliq_eclip}
\alias{obliq_corr}
\alias{sun_rt_ascen}
\alias{sun_decline}
\alias{var_y}
\alias{eq_of_time}
\alias{ha_sunrise}
\alias{solar_noon}
\alias{sunrise}
\alias{sunset}
\alias{sunlight_duration}
\alias{solar_datetime}
\alias{solar_tod}
\alias{hour_angle}
\alias{zenith_angle}
\alias{elevation_angle}
\alias{atm_refraction_approx}
\alias{azimuth_angle}
\title{Solar astronomy using Meeus' algorithm}
\format{An object of class \code{POSIXct} (inherits from \code{POSIXt}) of length 1.}
\usage{
calendar_change

julian_day(time)

julian_day_fast(time)

julian_century(time)

geom_mean_lon_sun(x)

geom_mean_anom_sun(x)

eccent_earth_orbit(x)

sun_eq_of_ctr(x, anom)

sun_rad_vector(eccent, anom)

sun_app_lon(x, lon)

mean_obliq_eclip(x)

obliq_corr(x, eclip)

sun_rt_ascen(app.lon, obliq.corr)

sun_decline(app.lon, obliq.corr)

var_y(obliq.corr)

eq_of_time(mean.lon, eccent.earth, anom.mean, var.y)

ha_sunrise(lat, decline, nag = 0)

solar_noon(lon, eq.of.time)

sunrise(noon, ha.sunrise)

sunset(noon, ha.sunrise)

sunlight_duration(ha.sunrise, unit.out = "hours")

solar_datetime(time, lat, lon, eq.of.time)

solar_tod(time, lat, lon, eq.of.time)

hour_angle(solar.time)

zenith_angle(lat, hour.angle, decline)

elevation_angle(lat, hour.angle, decline)

atm_refraction_approx(elevation.angle)

azimuth_angle(lat, hour.angle, zenith.angle, decline)
}
\arguments{
\item{time}{dateTime}

\item{x}{numeric Julian century}

\item{anom}{numeric Solar anomaly in degrees}

\item{eccent}{numeric Eccentricity of Earth orbit}

\item{eclip}{numeric Ecliptic}

\item{app.lon, obliq.corr, mean.lon, nag, decline}{numeric Angles in degrees}

\item{lat, lon}{numeric Geographic coordinates in degrees}

\item{eq.of.time, ha.sunrise, noon}{numeric}

\item{zenith.angle, elevation.angle, hour.angle}{numeric Angles in degrees}
}
\value{
datetime

numeric
}
\description{
The exact julian day computation is adapted from ode::julianDay() and tested
againts test cases in Redas and Andreas (2008, table A4.1) for validity up
to year 4712 BC.
}
\details{
Low level functions based on NOAA's Excel worksheet
}
\keyword{datasets}
\keyword{internal}
