% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{setRfrType}
\alias{setRfrType}
\title{Set the "Rfr.type" attribute}
\usage{
setRfrType(x, Rfr.type = c("total", "specular"))
}
\arguments{
\item{x}{a reflector_spct or an object_spct object}

\item{Rfr.type}{a character string, either "total" or "specular"}
}
\value{
x
}
\description{
Function to set by reference the "Rfr.type" attribute  of an existing
reflector_spct or object_spct object.
}
\note{
This function alters x itself by reference and in addition
  returns x invisibly. If x is not a reflector_spct or object_spct object, x is not modified.
  The behaviour of this function is 'unusual' in that the default for
  parameter Rfr.type is used only if \code{x} does not already have this
  attribute set.
}
\examples{
my.spct <- reflector_spct(w.length = 400:409, Rfr = 0.1)
getRfrType(my.spct)
setRfrType(my.spct, "specular")
getRfrType(my.spct)

}
\seealso{
Other Rfr attribute functions: \code{\link{getRfrType}},
  \code{\link{getScaled}}
}
\concept{Rfr attribute functions}
