% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.sd.r
\name{s_sd}
\alias{s_sd}
\alias{s_sd.default}
\alias{s_sd.filter_mspct}
\alias{s_sd.source_mspct}
\alias{s_sd.response_mspct}
\alias{s_sd.reflector_mspct}
\title{Standard Deviation of a collection of spectra}
\usage{
s_sd(x, na.rm, ...)

\method{s_sd}{default}(x, na.rm = FALSE, ...)

\method{s_sd}{filter_mspct}(x, na.rm = FALSE, ...)

\method{s_sd}{source_mspct}(x, na.rm = FALSE, ...)

\method{s_sd}{response_mspct}(x, na.rm = FALSE, ...)

\method{s_sd}{reflector_mspct}(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{An R object. Currently this package defines methods for collections
of spectral objects.}

\item{na.rm}{logical. A value indicating whether NA values should be stripped
before the computation proceeds.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
If \code{x} is a collection spectral of objects, such as a
  "filter_mspct" object, the returned object is of class "generic_spct",
  containing the standard deviation among the spectra at each wavelength
  in a column with name ending in ".sd".
}
\description{
A method to compute the standard deviation of values across members of a
collections of spectra. Computes the standard deviation at each wavelength
across all the spectra in the collection returning a spectral object.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: 

\item \code{filter_mspct}: 

\item \code{source_mspct}: 

\item \code{response_mspct}: 

\item \code{reflector_mspct}: 
}}

\note{
Omission of NAs is done separately at each wavelength. Interpolation is
  not applied, so all spectra in \code{x} must share the same set of
  wavelengths.
}
\seealso{
See \code{\link[stats]{sd}} for details about \code{sd()} methods
  for other classes.
}
