% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{insert_hinges}
\alias{insert_hinges}
\title{Insert wavelength values into spectral data.}
\arguments{
\item{x}{numeric array}

\item{y}{numeric array}

\item{hinges}{a numeric array giving the wavelengths at which the s.irrad
should be inserted by interpolation, no interpolation is indicated by an
empty array (numeric(0))}
}
\value{
a data.frame with variables \code{w.length} and \code{s.irrad}
}
\description{
Inserting wavelengths values immediately bafore and after a discontinuity in
the SWF, gretaly reduces the errors caused by interpolating the weighted
irradiance during integration of the effective spectral irradiance. This is
specially true when data has a large wavelength step size.
}
\examples{
with(sun.data,
    insert_hinges(w.length, s.e.irrad,
       c(399.99,400.00,699.99,700.00)))
with(sun.data,
    insert_hinges(w.length, s.e.irrad,
      c(199.99,200.00,399.50,399.99,400.00,699.99,700.00,799.99,1000.00)))
}
\keyword{manip}
\keyword{misc}

