% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.methods.R, R/spct.absorptance.R
\name{absorptance.filter_mspct}
\alias{absorptance}
\alias{absorptance.default}
\alias{absorptance.filter_mspct}
\alias{absorptance.filter_spct}
\alias{absorptance.object_mspct}
\alias{absorptance.object_spct}
\title{Absorptance}
\usage{
\method{absorptance}{filter_mspct}(spct, w.band = NULL,
  quantity = "average", wb.trim = getOption("photobiology.waveband.trim",
  default = TRUE), use.hinges = getOption("photobiology.use.hinges", default =
  NULL), ..., idx = !is.null(names(spct)))

\method{absorptance}{object_mspct}(spct, w.band = NULL,
  quantity = "average", wb.trim = getOption("photobiology.waveband.trim",
  default = TRUE), use.hinges = getOption("photobiology.use.hinges", default =
  NULL), ..., idx = !is.null(names(spct)))

absorptance(spct, w.band, quantity, wb.trim, use.hinges, ...)

\method{absorptance}{default}(spct, w.band, quantity, wb.trim, use.hinges, ...)

\method{absorptance}{object_spct}(spct, w.band = NULL, quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = getOption("photobiology.use.hinges", default = NULL), ...)

\method{absorptance}{filter_spct}(spct, w.band = NULL, quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = getOption("photobiology.use.hinges", default = NULL), ...)
}
\arguments{
\item{spct}{an R object}

\item{w.band}{waveband or list of waveband objects The waveband(s) determine
the region(s) of the spectrum that are summarized.}

\item{quantity}{character}

\item{wb.trim}{logical Flag if wavebands crossing spectral data boundaries
are trimmed or ignored}

\item{use.hinges}{logical Flag indicating whether to use hinges to reduce
interpolation errors}

\item{...}{other arguments (possibly ignored)}

\item{idx}{logical whether to add a column with the names of the elements of
spct}
}
\value{
A single numeric value with no change in scale factor, except in the
case of percentages (absorptance is the fraction absorbed)
}
\description{
Function to calculate the mean, total, or other summary of absorptance for
spectral data stored in a \code{filter_spct} or in an \code{object_spct}.
Absorptance is a different quantity than absorbance.
}
\section{Methods (by class)}{
\itemize{
\item \code{filter_mspct}: Calculates absorptance from a \code{filter_mspct}

\item \code{object_mspct}: Calculates absorptance from a \code{object_mspct}

\item \code{default}: Default for generic function

\item \code{object_spct}: Specialization for object spectra

\item \code{filter_spct}: Specialization for filter spectra
}}
\note{
The \code{use.hinges} parameter controls speed optimization. The
  defaults should be suitable in most cases. Only the range of wavelengths
  in the wavebands is used and all BSWFs are ignored.
}
\examples{
absorptance(yellow_gel.spct, new_waveband(400,500))
absorptance(yellow_gel.spct, new_waveband(300,400))

}

