% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.classes.R
\name{subset2mspct}
\alias{subset2mspct}
\title{Convert 'long' or tidy spectral data into a collection of spectra}
\usage{
subset2mspct(x, member.class = NULL, idx.var = "spct.idx",
  drop.idx = TRUE, ncol = 1, byrow = FALSE, ...)
}
\arguments{
\item{x}{a generic_spct object or a derived class, or a data frame}

\item{member.class}{character string}

\item{idx.var}{character Name of column containing data to be copied
unchanged to each spct object}

\item{drop.idx}{logical Flag indicating whether to drop or keep idx.var in
the collection members.}

\item{ncol}{integer Number of 'virtual' columns in data}

\item{byrow}{logical If \code{ncol > 1} how to read in the data}

\item{...}{additional arguments}
}
\description{
Convert a data frame object or spectral object into a collection
  of soectra object of the corresponding class. For data frames converting
  numeric columns other than wavelength into individual spct objects.
}
\note{
A non-null value for \code{member.class} is mandatory only when
  \code{x} is a data frame.
}
\seealso{
Other collections of spectra classes family: \code{\link{generic_mspct}},
  \code{\link{split2mspct}}
}

