#' Spectral data for filters of different 'colors'
#'
#' Names of datasets containing the wavelengths and tabulated values for
#' fractional spectral trabsmittance for filters of given colours.
#'
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#'
#' @aliases colors
#'
#' @examples
#' clear_filters
#'
#' # select filters of amber, yellow, orange color ("blue absorbing")
#' filters.mspct[yellow_filters]
#'
#' @seealso \code{\link{filters.mspct}}
#'
"clear_filters"

#' @rdname clear_filters
#'
"neutral_filters"

#' @rdname clear_filters
#'
"uv_filters"

#' @rdname clear_filters
#'
"blue_filters"

#' @rdname clear_filters
#'
"blue_green_filters"

#' @rdname clear_filters
#'
"green_filters"

#' @rdname clear_filters
#'
"yellow_filters"

#' @rdname clear_filters
#'
"orange_filters"

#' @rdname clear_filters
#'
"red_nir_filters"

#' @rdname clear_filters
#'
"heat_filters"

#' @rdname clear_filters
#'
"uvir_cut_filters"

