% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foreign-conversion.r
\name{colorSpec2mspct}
\alias{colorSpec2mspct}
\alias{colorSpec2spct}
\alias{colorSpec2chroma_spct}
\alias{mspct2colorSpec}
\alias{spct2colorSpec}
\alias{chroma_spct2colorSpec}
\title{Convert 'colorSpec::colorSpec' objects}
\usage{
colorSpec2mspct(x, multiplier = 1, ...)

colorSpec2spct(x, multiplier = 1, ...)

colorSpec2chroma_spct(x, multiplier = 1, ...)

mspct2colorSpec(x, spct.data.var = NULL, multiplier = 1, ...)

spct2colorSpec(x, spct.data.var = NULL, multiplier = 1, ...)

chroma_spct2colorSpec(x, spct.data.var = NULL, multiplier = 1, ...)
}
\arguments{
\item{x}{colorSpec object}

\item{multiplier}{numeric A multiplier to be applied to the 'spc' data to do
unit or scale conversion.}

\item{...}{currently ignored.}

\item{spct.data.var}{character The name of the variable to read spectral data
from.}
}
\description{
Convert 'colorSpec::colorSpec' objects into spectral objects (xxxx_spct,
xxxx_mspct) as defined in package 'photobiology' and vice veersa preserving
as much information as possible.
}
\note{
Objects of class \code{colorSpec::colorSpec} do not contain metadata or
  class data from which the units of expression could be obtained. When using
  this function the user needs to use parameter \code{multiplier} to convert 
  the data to what is expected by the object constructors defined in package 
  'photobiology' but should only rarely need to use parameter
  \code{spct.data.var} to select the quantity.
  
  \code{colorSpec::colorSpec} objects may use memory more efficiently than
  spectral objects of the classes for collections of spectra defined in
  package 'photobiology' as wavelengths are assumed to be the same for all
  member spectra, and stored only once while this assumption is not made for
  collections of spectra, allowing different wavelengths and lengths for the
  component spectra. Wavelengths are stored for each spectrum, but as
  spectral classes are derived from 'tbl_df' in many cases no redundant
  copies of wavelength data will be made in memory in spite of the more
  flexible semantics of the objects.
}
\section{Warning!}{
 Always check the sanity of the imported or exported data
  values, as guessing is needed when matching the different classes, and the
  functions defined here are NOT guaranteed to return valid data wihtout help
  from the user through optional function arguments.
}

\examples{

library(colorSpec)
colorSpec2mspct(Fs.5nm)
colorSpec2spct(Fs.5nm)
colorSpec2mspct(C.5nm)
colorSpec2spct(C.5nm)

}
