% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foreign-conversion.r
\name{mat2mspct}
\alias{mat2mspct}
\title{Convert a matrix into a collection of spectra}
\usage{
mat2mspct(x, w.length, member.class, spct.data.var, multiplier = 1,
  byrow = NULL, spct.names = "spct_", ...)
}
\arguments{
\item{x}{matrix object.}

\item{w.length}{numeric A vector of walength values sorted in strictly ascending
order (nm).}

\item{member.class}{character The name of the class of the individual spectra
to be constructed.}

\item{spct.data.var}{character The name of the variable that will contain the 
spectral data. This indicates what physical quantity is stored in the matrix 
and the units of expression used.}

\item{multiplier}{numeric A multiplier to be applied to the values in \code{x} to do
unit or scale conversion.}

\item{byrow}{logical Flag indicating whether each spectrum is stored in a row or
a column of the matrix. By default this value is set based on the length of
\code{w.length} and the dimensions of \code{x}.}

\item{spct.names}{character Vector of names to be assigned to collection members,
either of length 1, or with length equal to the number of spectra.}

\item{...}{other arguments passed to the constructor of collection members.}
}
\description{
Convert an R object of class matrix into a \code{generic_mspct} or a derived 
class.
}
\note{
Only \code{matrix} objects that have rows or columns of the same length
  as the numeric vector of walengths supplied can be converted. The resulting
  spectra will be built using the constructors and subjected to the same
  checks as if built individually. Only collections with all members of the
  same class can be built with this function. Additional named arguments can
  be supplied to set the same metadata attributes to all the member spectra.
  In the case of square matrices, an explicit argument is needed for
  \code{byrow} making it good practice for scripts and package code to not
  rely on the automatic default.
}
\examples{

x <- matrix(1:100, ncol = 2)
wl <- (301:350)
z <- mat2mspct(x, wl, "filter_spct", "Tpc")

x <- matrix(1:100, nrow = 2, byrow = TRUE)
wl <- (301:350)
z <- mat2mspct(x, wl, "filter_spct", "Tpc", byrow = TRUE, spct.name = c("A", "B"))

}
