% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-oopi-file.r
\name{read_oo_pidata}
\alias{read_oo_pidata}
\title{Read File Saved by Ocean Optics' Raspberry Pi software.}
\usage{
read_oo_pidata(file, date = NULL, geocode = NULL, label = NULL,
  tz = NULL, locale = readr::default_locale(), npixels = 2048)
}
\arguments{
\item{file}{character string}

\item{date}{a \code{POSIXct} object, but if \code{NULL} the date stored in
file is used, and if \code{NA} no date variable is added}

\item{geocode}{A data frame with columns \code{lon} and \code{lat}.}

\item{label}{character string, but if \code{NULL} the value of \code{file} is
used, and if \code{NA} the "what.measured" attribute is not set.}

\item{tz}{character Time zone is not saved to the file.}

\item{locale}{The locale controls defaults that vary from place to place. The
default locale is US-centric (like R), but you can use
\code{\link[readr]{locale}} to create your own locale that controls things
like the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{npixels}{integer Number of pixels in spectral data.}
}
\value{
A raw_spct object.
}
\description{
Reads and parses the header of a raw data file as output by the server
running on a Raspberry Pi board to extract the whole header remark field. The
time field is retrieved and decoded.
}
\note{
The header in these files has very little information, so the user
needs to supply the number of pixels in the array as well as the date-time.
The file contains a date in milliseconds but as the Raspberry Pi board
contains no real-time clock, it seems to default to number of milliseconds
since the Pi was switched on.
}
\references{
\url{http://www.r4photobiology.info} \url{http://oceanoptics.com/} \url{https://www.raspberrypi.org/}
}
