% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-fmi-cum.R
\name{read_fmi2mspct}
\alias{read_fmi2mspct}
\title{Read multiple solar spectra from a data file.}
\usage{
read_fmi2mspct(
  file,
  geocode = NULL,
  label = NULL,
  tz = NULL,
  locale = readr::default_locale(),
  .skip = 3,
  .n_max = -1
)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data (either a
single string or a raw vector).}

\item{geocode}{A data frame with columns \code{lon} and \code{lat} used to
set attribute \code{"where.measured"}.}

\item{label}{character string, but if \code{NULL} the value of \code{file} is
used, and if \code{NA} the "what.measured" attribute is not set.}

\item{tz}{character Time zone used for interpreting times saved in the
file header.}

\item{locale}{The locale controls defaults that vary from place to place. The
default locale is US-centric (like R), but you can use
\code{\link[readr]{locale}} to create your own locale that controls things
like the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{.skip}{Number of lines to skip before reading data.}

\item{.n_max}{Maximum number of records to read.}
}
\value{
\code{read_fmi2mspct()} returns a \code{source_mspct} object 
  containing \code{source_spct} objects as members, \code{time.unit} 
  attribute set to \code{"second"} and \code{when.measured}
  attribute set to the date-time values extracted from the file body.
}
\description{
Read spectral irradiance file as output by Anders Lindors' model based on
libRadTrans for hourly simulation.
}
\note{
See \code{\link[readr]{read_table}} for details of acceptable values
 for \code{file}.
}
