% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foreign-conversion.r
\name{colorSpec2mspct}
\alias{colorSpec2mspct}
\alias{as.source_spct.colorSpec}
\alias{as.source_mspct.colorSpec}
\alias{as.response_spct.colorSpec}
\alias{as.response_mspct.colorSpec}
\alias{as.filter_spct.colorSpec}
\alias{as.filter_mspct.colorSpec}
\alias{as.reflector_spct.colorSpec}
\alias{as.reflector_mspct.colorSpec}
\alias{as.chroma_mspct.colorSpec}
\alias{colorSpec2spct}
\alias{colorSpec2chroma_spct}
\alias{as.chroma_spct.colorSpec}
\alias{as.generic_spct.colorSpec}
\alias{as.generic_mspct.colorSpec}
\title{Convert 'colorSpec::colorSpec' objects}
\usage{
colorSpec2mspct(x, multiplier = 1, ...)

\method{as.source_spct}{colorSpec}(x, multiplier = 1, ...)

\method{as.source_mspct}{colorSpec}(x, multiplier = 1, ...)

\method{as.response_spct}{colorSpec}(x, multiplier = 1, ...)

\method{as.response_mspct}{colorSpec}(x, multiplier = 1, ...)

\method{as.filter_spct}{colorSpec}(x, multiplier = 1, ...)

\method{as.filter_mspct}{colorSpec}(x, multiplier = 1, ...)

\method{as.reflector_spct}{colorSpec}(x, multiplier = 1, ...)

\method{as.reflector_mspct}{colorSpec}(x, multiplier = 1, ...)

\method{as.chroma_mspct}{colorSpec}(x, multiplier = 1, ...)

colorSpec2spct(x, multiplier = 1, ...)

colorSpec2chroma_spct(x, multiplier = 1, ...)

\method{as.chroma_spct}{colorSpec}(x, multiplier = 1, ...)

\method{as.chroma_mspct}{colorSpec}(x, multiplier = 1, ...)

\method{as.generic_spct}{colorSpec}(x, multiplier = 1, ...)

\method{as.generic_mspct}{colorSpec}(x, multiplier = 1, ...)
}
\arguments{
\item{x}{colorSpec object}

\item{multiplier}{numeric A multiplier to be applied to the 'spc' data to do
unit or scale conversion.}

\item{...}{currently ignored.}
}
\description{
Convert 'colorSpec::colorSpec' objects into spectral objects (xxxx_spct,
xxxx_mspct) as defined in package 'photobiology' and vice versa preserving
as much information as possible.
}
\details{
Objects of class \code{colorSpec::colorSpec} do not contain metadata
or class data from which the units of expression could be obtained. When
using function \code{colorSpec2mspct} the user needs to use parameter
\code{multiplier} to convert the data to what is expected by the object
constructors defined in package 'photobiology' but should only rarely need to
use parameter \code{spct.data.var} to select the quantity.

\code{colorSpec::colorSpec} objects may use memory more efficiently than
spectral objects of the classes for collections of spectra defined in package
'photobiology' as wavelengths are assumed to be the same for all member
spectra, and stored only once while this assumption is not made for
collections of spectra, allowing different wavelengths and lengths for the
component spectra. When using \code{as.colorSpec} methods to convert
collections of spectra into \code{colorSpec} objects, if the wavelengths of
the individual spectra differe, only the shared range of wavelengths is
retained and within the this range, wavelngth values are made consistent by
interpolation.
}
\note{
In \code{generic_mspct} objects, wavelengths are stored for each
  spectrum, individual \code{generic_spct} objects. However, as spectral
  classes are derived from 'tbl_df' in many cases no redundant copies of
  wavelength data will be made in memory in spite of the more flexible
  semantics of the objects.
}
\section{Warning!}{
 Always check the sanity of the imported or exported data
  values, as guessing is needed when matching the different classes, and the
  functions defined here are NOT guaranteed to return valid data without help
  from the user through optional function arguments.
}

\examples{
# example run only if 'colorSpec' is available
if (requireNamespace("colorSpec", quietly = TRUE)) {
  library(colorSpec)
  colorSpec2mspct(Fs.5nm)
  colorSpec2spct(Fs.5nm)
  colorSpec2mspct(C.5nm)
  colorSpec2spct(C.5nm)
} 

}
