#' Spectral data for LEDs array supplied by Huey Jann
#'
#' Datasets containing the wavelengths and
#' tabulated values spectral emittance for different light emitting diodes (LEDs) arrays
#' from Huey Jann Electronics Industry Co., Ltd. (Taiwan).
#' Absolute values are not meaningful as the measuring distances are variable, and in most cases unknown.
#' 
#' The variables are as follows:
#' \itemize{
#'   \item w.length (nm)  
#'   \item s.e.irrad (W m-2 nm-1)
#' }
#' 
#' @note
#' Huey Jann was a Taiwanese supplier of LED array. It is no longer in
#' business.
#'
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#' 
#' @examples 
#' huey_jann
#' leds.mspct[huey_jann]
#' 
"huey_jann"
