#' @title Analytik-Jena sensors.
#'
#' @description A vector of names useful for extracting subsets of spectra from
#'   the \code{\link{sensors.mspct}} object.
#'
#' @format A character vector of names of members of the collection of spectra.
#'
#' @docType data
#' @keywords datasets
#'
#' @details
#' UVX-25, UVX-31 and UVX-36 sensor for UV-C, UV-B and UV-A radiation,
#' respectively. Detection system includes optical filters and a Si photodiode.
#'
#' @note
#' Digitized with 'DigitizeIt' from figures 6, 7 and 8 from manufacturers
#' product manual. This are approximate data, both because of the digitizing
#' process, and because they are either typical values or for a particular
#' sensor unit. Individual sensor units are expected to differ to some degree in
#' spectral response.
#'
#' Manufacturer: Analytik Jena US LLC, Upland, CA, USA (former UVP)
#' \url{https://www.analytik-jena.com/} or \url{https://www.uvp.com/}.
#'
#' @references
#' Product manual: 'UVP UVX Radiometer: Instruction Guide'
#'
#' @examples
#'
#' analytik_sensors
#'
"analytik_sensors"
