% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/red.r
\name{Red}
\alias{Red}
\title{Definition of red waveband}
\usage{
Red(std = "ISO")
}
\arguments{
\item{std}{a character string, defaults to "ISO".}
}
\value{
a waveband object wavelength defining a wavelength range.
}
\description{
Red radiation according to "ISO" (610-760 nm) or as commonly defined in plant
photobiology, "Smith10" (655-665 nm), "Smith20" (650-670 nm), "Inada"
(600-700 nm), "Warrington" (625-675 nm), and "Sellaro" (620-680 nm). No
weighting applied.
}
\examples{
Red()
Red("ISO")
Red("Smith")
Red("Sellaro")

}
\references{
Aphalo, P. J., Albert, A., Björn, L. O., McLeod, A. R., Robson,
T. M., Rosenqvist, E. (Eds.). (2012). Beyond the Visible: A handbook of best
practice in plant UV photobiology (1st ed., p. xxx + 174). Helsinki:
University of Helsinki, Department of Biosciences, Division of Plant Biology.
ISBN 978-952-10-8363-1 (PDF), 978-952-10-8362-4 (paperback). Open access PDF
download available at http://hdl.handle.net/10138/37558

ISO (2007) Space environment (natural and artificial) - Process for
determining solar irradiances. ISO Standard 21348. ISO, Geneva.

Murakami, K., Aiga I. (1994) Red/Far-red photon flux ratio used as an index
number for morphological control of plant growth under artificial lighting
conditions. Proc. Int. Symp. Artificial Lighting, Acta Horticulturae, 418,
ISHS 1997.

Sellaro, R., Crepy, M., Trupkin, S. A., Karayekov, E., Buchovsky, A. S.,
Rossi, C., & Casal, J. J. (2010). Cryptochrome as a sensor of the blue/green
ratio of natural radiation in Arabidopsis. Plant physiology, 154(1), 401-409.
doi:10.1104/pp.110.160820

Smith, H. (1982) Light quality, photoperception and plant strategy. Annual
Review of Plant Physiology, 33:481-518.
}
\seealso{
\code{\link[photobiology]{waveband}}

Other unweighted wavebands: \code{\link{Blue}},
  \code{\link{Far_red}}, \code{\link{Green}},
  \code{\link{Orange}}, \code{\link{Purple}},
  \code{\link{UVA}}, \code{\link{UVB}}, \code{\link{UVC}},
  \code{\link{UV}}, \code{\link{VIS}}, \code{\link{Yellow}}
}

