% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse.R
\name{reverse}
\alias{reverse}
\title{Reverse geocoding}
\usage{
reverse(
  .data,
  radius = NULL,
  limit = 1,
  lang = "en",
  osm_tag = NULL,
  layer = NULL,
  locbias = NULL,
  locbias_scale = NULL,
  zoom = NULL,
  distance_sort = TRUE,
  progress = interactive()
)
}
\arguments{
\item{.data}{A dataframe or list with names \code{lon} and \code{lat}, or
an \code{sfc} or \code{sf} object containing point geometries.}

\item{radius}{Numeric specifying the range around the points in \code{.data}
that is used for searching.}

\item{limit}{Number of results to return. A maximum of 50 results can be
returned for a single search term. Defaults to 1. When more than a single
text is provided but limit is greater than 1, the results can be uniquely
linked to the input texts using the \code{idx} column in the output.}

\item{lang}{Language of the results. If \code{"default"}, returns the results
in local language.}

\item{osm_tag}{Character string giving an
\href{https://wiki.openstreetmap.org/wiki/Tags}{OSM tag} to filter the
results by. See details.}

\item{layer}{Character string giving a layer to filter the results by.
Can be one of \code{"house"}, \code{"street"}, \code{"locality"},
\code{"district"}, \code{"city"}, \code{"county"}, \code{"state"},
\code{"country"}, or \code{"other"}.}

\item{locbias}{Numeric vector of length 2 or any object that can be coerced
to a length-2 numeric vector (e.g. a list or \code{sfg} object). Specifies a
location bias for geocoding in the format \code{c(lon, lat)}. Geocoding
results are biased towards this point. The radius of the bias is controlled
through \code{zoom} and the weight of place prominence through
\code{location_bias_scale}.}

\item{locbias_scale}{Numeric vector specifying the importance of prominence
in \code{locbias}. A higher prominence scale gives more weight to important
places. Possible values range from 0 to 1. Defaults to 0.2.}

\item{zoom}{Numeric specifying the radius for which the \code{locbias} is
effective. Corresponds to the zoom level in OpenStreetMap. The exact relation
to \code{locbias} is \eqn{0.25\text{ km} \cdot 2^{(18 - \text{zoom})}}.
Defaults to 16.}

\item{distance_sort}{If \code{TRUE}, sorts the reverse geocoding results
based on the distance to the input point. Defaults to \code{TRUE}.}

\item{progress}{If \code{TRUE}, shows a progress bar for longer queries.}
}
\value{
An sf dataframe or tibble containing the following columns:

\itemize{
\item{\code{idx}: Internal ID specifying the index of the \code{texts}
parameter.}
\item{\code{osm_type}: Type of OSM element, one of N (node), W (way),
R (relation), or P (polygon).}
\item{\code{osm_id}: OpenStreetMap ID of the matched element.}
\item{\code{country}: Country of the matched place.}
\item{\code{city}: City of the matched place.}
\item{\code{osm_key}: OpenStreetMap key.}
\item{\code{countrycode}: ISO2 country code.}
\item{\code{housenumber}: House number, if applicable.}
\item{\code{postcode}: Post code, if applicable.}
\item{\code{locality}: Locality, if applicable.}
\item{\code{street}: Street, if applicable.}
\item{\code{district}: District name, if applicable.}
\item{\code{osm_value}: OpenStreetMap tag value.}
\item{\code{name}: Place name.}
\item{\code{type}: Layer type as described for the \code{layer} parameter.}
\item{\code{extent}: Boundary box of the match.}
}
}
\description{
Reverse geocode a set of points to retrieve their corresponding place names.
To geocode a place name or an address, see \link[=geocode]{unstructured}
or \link[=structured]{structured} geocoding.
}
\details{
Filtering by OpenStreetMap tags follows a distinct syntax explained on
\url{https://github.com/komoot/photon}. In particular:

\itemize{
\item{Include places with tag: \code{key:value}}
\item{Exclude places with tag: \code{!key:value}}
\item{Include places with tag key: \code{key}}
\item{Include places with tag value: \code{:value}}
\item{Exclude places with tag key: \code{!key}}
\item{Exclude places with tag value: \code{:!value}}
}
}
\examples{
\donttest{# an instance must be mounted first
photon <- new_photon()

# works with sf objects
sf_data <- sf::st_sfc(sf::st_point(c(8, 52)), sf::st_point(c(7, 52)), crs = 4326)
reverse(sf_data)

# ... but also with simple dataframes
df_data <- data.frame(lon = c(8, 7), lat = c(52, 52))
reverse(df_data)

# limit search radius to 10m
reverse(df_data, radius = 10)}
}
