% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aq_response.R
\name{aq_response}
\alias{aq_response}
\title{Non-rectangular hyperbolic model of light responses}
\usage{
aq_response(k_sat, phi_J, Q_abs, theta_J)
}
\arguments{
\item{k_sat}{Light saturated rate of process k}

\item{phi_J}{Quantum efficiency of process k}

\item{Q_abs}{Absorbed light intensity (umol m-2 s-1)}

\item{theta_J}{Curvature of the light response}
}
\value{
aq_response is used to describe the response of a process to
absorbed light intensity. Assumes that input is absorbed light. Note
that if absorbed light is not used, then the meaning of phi_J becomes
unclear. This function is designed to be used with fit_aq_response,
however it could easily be fed into a different fitting approach (e.g.
Bayesian approaches). Originally from Marshall et al. 1980.
}
\description{
`r lifecycle::badge("deprecated")`

Please use `marshall_biscoe_1980()`.
}
\references{
Marshall B, Biscoe P. 1980. A model for C3 leaves describing the
dependence of net photosynthesis on irradiance. J Ex Bot 31:29-39
}
