% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_photosynthesis.R
\name{fit_photosynthesis}
\alias{fit_photosynthesis}
\title{Fit photosynthetic models with gas-exchange data}
\usage{
fit_photosynthesis(
  .data,
  .photo_fun,
  .model = "default",
  .vars = NULL,
  .method = "ls",
  ...,
  quiet = FALSE,
  brm_options = NULL
)
}
\arguments{
\item{.data}{A data frame containing plant ecophysiological data. See \code{\link{required_variables}} for the variables required for each model.}

\item{.photo_fun}{A character string of \strong{photosynthesis} function to call. One of: \code{aq_response, r_light}.}

\item{.model}{A character string of model name to use. See \code{\link{get_all_models}}.}

\item{.vars}{A list to rename variables in .data. See \code{\link{required_variables}} for the accepted variable names.}

\item{.method}{A character string of the statistical method to use: 'ls' for least-squares and 'brms' for Bayesian model using \code{\link[brms]{brm}}. Default is 'ls'.}

\item{...}{Additional arguments passed to specific models. See specific help pages for each type of photosynthetic model:
\itemize{
\item Light-response curves \code{\link{fit_aq_response2}}
\item Light respiration \code{\link{fit_r_light2}}
}}

\item{quiet}{Flag. Should messages be suppressed? Default is FALSE.}

\item{brm_options}{A list of options passed to \code{\link[brms]{brm}} if \code{.method = "brms"}. Default is NULL.}
}
\value{
A fitted model object
\itemize{
\item class 'lm' or 'nls' if \code{method = 'ls'}
\item class 'brmsfit' if \code{method = 'brms'}
}
}
\description{
Fit photosynthetic models with gas-exchange data
}
\note{
This function will fit models to data but several methods require post-processing to extract meaningful parameter estimates and confidence intervals. See vignettes for further explanation and examples.
\itemize{
\item Light-response curves: \code{vignette("light-response", package = "photosynthesis")}
\item Light respiration: \code{vignette("light-respiration", package = "photosynthesis")}
}
}
