\name{PLD_plot_trees}

\alias{PLD_plot_trees}

\title{
Plot sampled trees
}

\description{
Function that plots sampled trees with their locations.
}

\usage{
PLD_plot_trees(x, sub_sample = 0, one_plot = FALSE)
}

\arguments{
  \item{x}{
an object of class "phyloland" generated by a call to \link{PLD_interface}.
}

  \item{sub_sample}{
a vector of integers that specifies the indexes of the tree(s) to plot.
Default is 0, all the trees are plotted.
}

  \item{one_plot}{
a logical value.
Default is FALSE, the trees are plotted one after the other.
If TRUE the trees are plotted on the same device.
}
}

\examples{
data(Banza)
PLD_plot_trees(x = Banza, sub_sample = 1)
PLD_plot_trees(x = Banza, sub_sample = 100:105)
}
