% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAG.R
\name{average_DAGs}
\alias{average_DAGs}
\title{Perform model averaging on a list of DAGs.}
\usage{
average_DAGs(fitted_DAGs, weights = rep(1, length(coef)),
  avg_method = "conditional", ...)
}
\arguments{
\item{fitted_DAGs}{A list of \code{fitted_DAG} objects containing
coefficients and standard errors, usually obtained by using \code{\link[=est_DAG]{est_DAG()}}
on several DAGs.}

\item{weights}{A vector of associated model weights.}

\item{avg_method}{Either \code{"full"} or \code{"conditional"}. The methods
differ in how they deal with averaging a path coefficient where the path is
absent in some of the models. The full method sets the coefficient (and the
variance) for the missing paths to zero, meaning paths that are missing in
some models will shrink towards zero. The conditional method only averages
over models where the path appears, making it more sensitive to small
effects. Following von Hardenberg & Gonzalez-Voyer 2013, conditional
averaging is set as the default. Also see \code{\link[MuMIn:model.avg]{MuMIn::model.avg()}}.}

\item{...}{Additional arguments passed to \code{\link[MuMIn:par.avg]{MuMIn::par.avg()}}.

For details on the error calculations, see \code{\link[MuMIn:par.avg]{MuMIn::par.avg()}}.}
}
\value{
An object of class \code{fitted_DAG}, including standard errors and
confidence intervals.
}
\description{
Perform model averaging on a list of DAGs.
}
\examples{
  # Normally, I would advocate the use of the phylo_path and average
  # functions, but this code shows how to average any set of models. Note
  # that not many checks are implemented, so you may want to be careful and
  # make sure the DAGs make sense and contain the same variables!
  candidates <- list(A = DAG(LS ~ BM, NL ~ BM, DD ~ NL),
                     B = DAG(LS ~ BM, NL ~ LS, DD ~ NL))
  fit_cand <- lapply(candidates, est_DAG, rhino, rhino_tree,
                     model = 'lambda', method = 'logistic_MPLE')
  ave_cand <- average_DAGs(fit_cand)
  coef_plot(ave_cand)
}
