% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EDGE.R
\name{EDGE}
\alias{EDGE}
\title{Evolutionary Distinctiveness and Global Endangerment}
\usage{
EDGE(x, phy, Redlist = "Redlist", species = "species", ...)
}
\arguments{
\item{x}{a data.frame}

\item{phy}{a phylogenetic tree (object of class phylo).}

\item{Redlist}{column in the data frame with the IUCN ranks: \code{LC},
\code{NT}, \code{VU}, \code{EN}, \code{CR}, and \code{EX}.}

\item{species}{data frame column specifying the taxon}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
Returns a dataframe of EDGE scores
}
\description{
This function calculates EDGE by combining evolutionary distinctiveness
(ED; i.e., phylogenetic isolation of a species) with global endangerment
(GE) status as defined by the International Union for Conservation
of Nature (IUCN).
}
\details{
EDGE is calculated as: \deqn{log(1+ED) + GE*log(2)}
where \emph{ED} represents the evolutionary distinctiveness score of each
species (function \code{evol_distinct}), i.e. the degree of phylogenetic
isolation, and combining it with \emph{GE}, global endangerment from IUCN
conservation threat categories. \emph{GE} is calculated as the expected
probability of extinction over 100 years of each taxon in the phylogeny
(Redding & Mooers, 2006), scaled as follows: least concern = 0.001, near
threatened and conservation dependent = 0.01, vulnerable = 0.1,
endangered = 0.67, and critically endangered = 0.999.
}
\examples{
data(africa)
y <- EDGE(africa$IUCN, africa$phylo, Redlist = "IUCN", species="Species")
}
\references{
Redding, D.W., & Mooers, A.Ø. (2006) Incorporating evolutionary measures
into conservation prioritization. \emph{Conservation Biology}
\strong{20}: 1670–1678.

Isaac, N.J., Turvey, S.T., Collen, B., Waterman, C. & Baillie, J.E.
(2007) Mammals on the EDGE: conservation priorities based on threat
and phylogeny. \emph{PLoS ONE} \strong{2}: e296.
}
\author{
Barnabas H. Daru
}
