% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloregion.R
\name{phyloregion}
\alias{phyloregion}
\alias{infomap}
\title{Compute phylogenetic regionalization and evolutionary distinctiveness of phyloregions}
\usage{
phyloregion(x, k = 10, method = "average", pol = NULL, ...)

infomap(x, pol = NULL, ...)
}
\arguments{
\item{x}{A distance matrix}

\item{k}{The desired number of phyloregions, often as determined by
\code{optimal_phyloregion}.}

\item{method}{the agglomeration method to be used. This should be (an
unambiguous abbreviation of) one of \dQuote{ward.D}, \dQuote{ward.D2},
\dQuote{single},
\dQuote{complete}, \dQuote{average} (= UPGMA), \dQuote{mcquitty} (= WPGMA),
\dQuote{median}
(= WPGMC) or \dQuote{centroid} (= UPGMC).}

\item{pol}{a vector polygon of grid cells or spatial points.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
An object of class \code{phyloregion} containing
\itemize{
  \item a data frame membership with columns grids and cluster
  \item k the number of clusters
  and additionally there can be an shape file and other objects.
  This representation may still change.
}
}
\description{
This function estimates evolutionary distinctiveness of each phyloregion by
computing the mean value of phylogenetic beta diversity between a focal
phyloregion and all other phyloregions in the study area.
}
\examples{
library(ape)
tree <- read.tree(text = "((t1:1,t2:1)N2:1,(t3:1,t4:1)N3:1)N1;")
com <- sparseMatrix(c(1,3,4,1,4,5,1,2,3,4,5,6,3,4,6),
  c(1,1,1,2,2,2,3,3,3,3,3,3,4,4,4),x=1,
  dimnames = list(paste0("g", 1:6), tree$tip.label))
pbc <- phylobeta(com, tree)
# phyloregion(pbc[[1]], k = 3)
}
\references{
Daru, B.H., Van der Bank, M., Maurin, O., Yessoufou, K., Schaefer, H.,
Slingsby, J.A. & Davies, T.J. (2016) A novel phylogenetic regionalization of
the phytogeographic zones of southern Africa reveals their hidden
evolutionary affinities. \emph{Journal of Biogeography} \strong{43}: 155-166.

Daru, B.H., Elliott, T.L., Park, D.S. & Davies, T.J. (2017) Understanding the
processes underpinning patterns of phylogenetic regionalization.
\emph{Trends in Ecology and Evolution} \strong{32}: 845-860.

Daru, B.H., Holt, B.G., Lessard, J.P., Yessoufou, K. & Davies, T.J. (2017)
Phylogenetic regionalization of marine plants reveals close evolutionary
affinities among disjunct temperate assemblages.
\emph{Biological Conservation} \strong{213}: 351-356.
}
\seealso{
\code{\link{evol_distinct}}, \code{\link{optimal_phyloregion}},
\code{\link[picante]{evol.distinct}} for a different approach.
}
\author{
Barnabas H. Daru \email{darunabas@gmail.com}
}
\keyword{phyloregion}
