% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps_simulate.R
\name{ps_simulate}
\alias{ps_simulate}
\title{Simulate a toy spatial phylogenetic data set}
\usage{
ps_simulate(
  n_tips = 10,
  n_x = 20,
  n_y = 20,
  data_type = c("probability", "binary", "abundance"),
  spatial_type = c("raster", "none"),
  seed = NULL
)
}
\arguments{
\item{n_tips}{Number of terminals on phylogeny.}

\item{n_x}{Number of raster cells in x dimension of landscape.}

\item{n_y}{Number of raster cells in y dimension of landscape.}

\item{data_type}{Community data type for simulated ranges: either "probability" (default), "binary", or "abundance".}

\item{spatial_type}{Either "raster" or "none".}

\item{seed}{Optional integer to seed random number generator.}
}
\value{
\code{phylospatial} object, comprising a random phylogeny and community matrix in which each terminal has a
circular geographic range with a random radius and location. The spatial reference data is a SpatRaster.
}
\description{
This function generates a simple \code{phylospatial} object that can be used for testing other functions
in the package. It is not intended to be realistic.
}
\examples{
# using all the defaults
ps_simulate()

# specifying some arguments
plot(ps_simulate(n_tips = 50, n_x = 30, n_y = 40, data_type = "abundance"), "comm")
}
