% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline.R
\name{setup}
\alias{setup}
\title{Set-up parameters}
\usage{
setup(wd, txid, ncbi_dr = ".", v = FALSE, ...)
}
\arguments{
\item{wd}{Working directory}

\item{txid}{Root taxonomic ID(s), vector or numeric}

\item{ncbi_dr}{Directory to NCBI BLAST tools, default '.'}

\item{v}{Verbose, T/F}

\item{...}{Additional parameters}
}
\description{
Set up working directory with parameters.
}
\details{
See \code{\link{parameters}}() for a description of all parameters
and their defaults. You can change parameters after a folder has been set up
with \code{\link{parameters_reset}}().
}
\examples{
\dontrun{
  
  # Note: this example requires BLAST to run.
  
  # example with temp folder
  wd <- file.path(tempdir(), 'aotus')
  # setup for aotus, make sure aotus/ folder already exists
  if (!dir.exists(wd)) {
    dir.create(wd)
  }
  ncbi_dr <- '[SET BLAST+ BIN PATH HERE]'
  # e.g. "/usr/local/ncbi/blast/bin/"
  setup(wd = wd, txid = 9504, ncbi_dr = ncbi_dr)  # txid for Aotus primate genus
  # see ?parameters for all available parameter options
}
}
\seealso{
Other run-public: \code{\link{ClstrArc-class}},
  \code{\link{ClstrRec-class}},
  \code{\link{Phylota-class}}, \code{\link{SeqArc-class}},
  \code{\link{SeqRec-class}}, \code{\link{TaxDict-class}},
  \code{\link{TaxRec-class}}, \code{\link{clusters2_run}},
  \code{\link{clusters_run}},
  \code{\link{parameters_reset}}, \code{\link{reset}},
  \code{\link{restart}}, \code{\link{run}},
  \code{\link{taxise_run}}
}
