% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsa.R
\name{bsa}
\alias{bsa}
\alias{bsa_adult}
\alias{bsa_dubois_dubois}
\alias{bsa_mosteller}
\alias{bsa_haycock}
\alias{bsa_gehan_george}
\alias{bsa_boyd}
\alias{bsa_fujimoto}
\alias{bsa_takahira}
\alias{bsa_shuter_aslani}
\alias{bsa_schlich}
\title{Estimate body surface area}
\usage{
bsa_adult(height_m, weight_kg, ...)

bsa_dubois_dubois(height_m, weight_kg, ...)

bsa_mosteller(height_m, weight_kg, ...)

bsa_haycock(height_m, weight_kg, ...)

bsa_gehan_george(height_m, weight_kg, ...)

bsa_boyd(height_m, weight_kg, ...)

bsa_fujimoto(height_m, weight_kg, ...)

bsa_takahira(height_m, weight_kg, ...)

bsa_shuter_aslani(height_m, weight_kg, ...)

bsa_schlich(height_m, weight_kg, male, ...)
}
\arguments{
\item{height_m}{height(s) in meters}

\item{weight_kg}{numeric vector of weight(s) in kg}

\item{...}{passed to validation}

\item{male}{logical value(s) whether patient is male. TRUE or FALSE.}
}
\value{
numeric vector of body surface areas in m^2.
}
\description{
Estimate body surface area (BSA)
}
\details{
1.73 m^2 is commonly used as an average adult BSA.
}
\section{Functions}{
\itemize{
\item \code{bsa_adult}: Uses `bsa_mosteller()`

\item \code{bsa_dubois_dubois}: Du Bois and Du Bois formula (usually the preferred formula
for adults and children)

\item \code{bsa_mosteller}: Mosteller formula

\item \code{bsa_haycock}: Haycock formula

\item \code{bsa_gehan_george}: Gehan and George formula

\item \code{bsa_boyd}: Boyd formula

\item \code{bsa_fujimoto}: Fujimoto formula (often used for Japanese individuals)

\item \code{bsa_takahira}: Takahira formula (a variant of Du Bois that could be used for
Japanese individuals; Fujimoto may be preferred)

\item \code{bsa_shuter_aslani}: Shuter and Aslani formula

\item \code{bsa_schlich}: Schlich formula
}}

\examples{
bsa_dubois_dubois(2, 80)
bsa_dubois_dubois(1.5, 80)
stopifnot(
  identical(
    bsa_mosteller(1.5, 80),
    bsa_adult(1.5, 80)))
}
\references{
Du Bois D, Du Bois EF (Jun 1916). "A formula to estimate the
  approximate surface area if height and weight be known". Archives of
  Internal Medicine. 17 (6): 863–71.

Mosteller, RD (1987). "Simplified calculation of body-surface
  area". N Engl J Med. 317 (17): 1098.
  \url{https://www.ncbi.nlm.nih.gov/pubmed/3657876}

Haycock, GB, Schwartz, GJ, Wisotsky, DH (1978). Geometric method
  for measuring body surface area: A height-weight formula validated in
  infants, children and adults. J Pediatr. 93: 62–66.

Gehan EA, George SL, Cancer Chemother Rep 1970, 54:225-235

Boyd, Edith (1935). The Growth of the Surface Area of the Human
  Body. University of Minnesota. The Institute of Child Welfare, Monograph
  Series, No. x. London: Oxford University Press.

Fujimoto S, Watanabe T, Sakamoto A, Yukawa K, Morimoto K. Studies
  on the physical surface area of Japanese. 18. Calculation formulae in three
  stages over all ages. Nippon Eiseigaku Zasshi 1968;5:443–50.

Fujimoto S, Watanabe T, Sakamoto A, Yukawa K, Morimoto K. Studies
  on the physical surface area of Japanese. 18. Calculation formulae in three
  stages over all ages. Nippon Eiseigaku Zasshi 1968;5:443–50.

Shuter, B; Aslani, A (2000). "Body surface area: Du Bois and Du
  Bois revisited". European Journal of Applied Physiology. 82 (3): 250–254.

Schlich, E; Schumm, M; Schlich, M (2010). "3-D-Body-Scan als
  anthropometrisches Verfahren zur Bestimmung der spezifischen
  Körperoberfläche". Ernährungs Umschau. 57: 178–183.
}
\concept{body surface area}
