% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDI_quantregforest.R
\name{HDI_quantregforest}
\alias{HDI_quantregforest}
\title{Implements HDI RF prediction interval method in Zhu 2019. Helper function.}
\usage{
HDI_quantregforest(
  formula = NULL,
  train_data = NULL,
  test_data = NULL,
  alpha = NULL,
  num_tree = NULL,
  mtry = NULL,
  min_node_size = NULL,
  max_depth = NULL,
  replace = TRUE,
  verbose = FALSE,
  num_threads = NULL
)
}
\arguments{
\item{formula}{Object of class formula or character describing the model to fit. Interaction terms supported only for numerical variables.}

\item{train_data}{Training data of class data.frame, matrix, dgCMatrix (Matrix) or gwaa.data (GenABEL). Matches ranger() requirements.}

\item{test_data}{Test data of class data.frame, matrix, dgCMatrix (Matrix) or gwaa.data (GenABEL). Utilizes ranger::predict() to get prediction intervals for test data.}

\item{alpha}{Significance level for prediction intervals.}

\item{num_tree}{Number of trees.}

\item{mtry}{Number of variables to randomly select from at each split.}

\item{min_node_size}{Minimum number of observations before split at a node.}

\item{max_depth}{maximum depth of each tree in RF. ranger parameter.}

\item{replace}{Sample with replacement, or not. Utilized for the two different variants outlined in Ghosal, Hooker 2018. Currently variant 2 not implemented.}

\item{num_threads}{The number of threads to use in parallel. Default is the current number of cores.}
}
\description{
This function implements an HDI RF prediction interval method.
}
\keyword{internal}
